/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.operators;

import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleConverter;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

final class SingleFlatMapSignalMaybe<T, R>
extends Maybe<R>
implements SingleConverter<T, Maybe<R>> {
    final Single<T> source;
    final Function<? super T, ? extends MaybeSource<? extends R>> onSuccessHandler;
    final Function<? super Throwable, ? extends MaybeSource<? extends R>> onErrorHandler;

    SingleFlatMapSignalMaybe(Single<T> source, Function<? super T, ? extends MaybeSource<? extends R>> onSuccessHandler, Function<? super Throwable, ? extends MaybeSource<? extends R>> onErrorHandler) {
        this.source = source;
        this.onSuccessHandler = onSuccessHandler;
        this.onErrorHandler = onErrorHandler;
    }

    public Maybe<R> apply(Single<T> t) {
        return new SingleFlatMapSignalMaybe<T, R>(t, this.onSuccessHandler, this.onErrorHandler);
    }

    protected void subscribeActual(MaybeObserver<? super R> observer) {
        this.source.subscribe(new FlatMapSignalConsumer<T, R>(observer, this.onSuccessHandler, this.onErrorHandler));
    }

    static final class FlatMapSignalConsumer<T, R>
    implements SingleObserver<T>,
    Disposable {
        final SignalConsumer<R> consumer;
        final Function<? super T, ? extends MaybeSource<? extends R>> onSuccessHandler;
        final Function<? super Throwable, ? extends MaybeSource<? extends R>> onErrorHandler;

        FlatMapSignalConsumer(MaybeObserver<? super R> downstream, Function<? super T, ? extends MaybeSource<? extends R>> onSuccessHandler, Function<? super Throwable, ? extends MaybeSource<? extends R>> onErrorHandler) {
            this.consumer = new SignalConsumer<R>(downstream);
            this.onSuccessHandler = onSuccessHandler;
            this.onErrorHandler = onErrorHandler;
        }

        public void dispose() {
            DisposableHelper.dispose(this.consumer);
        }

        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)((Disposable)this.consumer.get()));
        }

        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate((Disposable)((Disposable)this.consumer.get()), (Disposable)d)) {
                this.consumer.lazySet(d);
                this.consumer.downstream.onSubscribe((Disposable)this);
            }
        }

        public void onSuccess(T t) {
            MaybeSource next;
            try {
                next = (MaybeSource)Objects.requireNonNull(this.onSuccessHandler.apply(t), "The onSuccessHandler returned a null MaybeSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe(this.consumer);
        }

        public void onError(Throwable e) {
            MaybeSource next;
            try {
                next = (MaybeSource)Objects.requireNonNull(this.onErrorHandler.apply((Object)e), "The onErrorHandler returned a null MaybeSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.consumer.onError(ex);
                return;
            }
            next.subscribe(this.consumer);
        }

        static final class SignalConsumer<R>
        extends AtomicReference<Disposable>
        implements MaybeObserver<R> {
            private static final long serialVersionUID = 314442824941893429L;
            final MaybeObserver<? super R> downstream;

            SignalConsumer(MaybeObserver<? super R> downstream) {
                this.downstream = downstream;
            }

            public void onSubscribe(Disposable d) {
                DisposableHelper.replace((AtomicReference)this, (Disposable)d);
            }

            public void onSuccess(R t) {
                this.downstream.onSuccess(t);
            }

            public void onError(Throwable e) {
                this.downstream.onError(e);
            }

            public void onComplete() {
                this.downstream.onComplete();
            }
        }
    }
}

