/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.parallel;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.parallel.ParallelTransformer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class ParallelSumLong<T extends Number>
extends ParallelFlowable<Long>
implements ParallelTransformer<T, Long> {
    final ParallelFlowable<? extends Number> source;

    ParallelSumLong(ParallelFlowable<? extends Number> source) {
        this.source = source;
    }

    public ParallelFlowable<Long> apply(ParallelFlowable<T> t) {
        return new ParallelSumLong<T>(t);
    }

    public void subscribe(Subscriber<? super Long>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            parents[i] = new SumIntSubscriber(subscribers[i]);
        }
        this.source.subscribe(parents);
    }

    public int parallelism() {
        return this.source.parallelism();
    }

    static final class SumIntSubscriber
    extends DeferredScalarSubscription<Long>
    implements FlowableSubscriber<Number> {
        private static final long serialVersionUID = -1502296701568087162L;
        long sum;
        boolean hasValue;
        Subscription upstream;

        SumIntSubscriber(Subscriber<? super Long> downstream) {
            super(downstream);
        }

        public void onNext(Number t) {
            if (!this.hasValue) {
                this.hasValue = true;
            }
            this.sum += t.longValue();
        }

        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        public void onComplete() {
            if (this.hasValue) {
                this.complete(this.sum);
            } else {
                this.downstream.onComplete();
            }
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void cancel() {
            super.cancel();
            this.upstream.cancel();
        }
    }
}

