/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.parallel;

import hu.akarnokd.rxjava3.parallel.ParallelOrderedMerge;
import hu.akarnokd.rxjava3.parallel.ParallelSumDouble;
import hu.akarnokd.rxjava3.parallel.ParallelSumInteger;
import hu.akarnokd.rxjava3.parallel.ParallelSumLong;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.parallel.ParallelTransformer;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Comparator;
import java.util.Objects;

public final class ParallelTransformers {
    private ParallelTransformers() {
        throw new IllegalStateException("No instances!");
    }

    public static <T extends Comparable<? super T>> Flowable<T> orderedMerge(ParallelFlowable<T> source) {
        return ParallelTransformers.orderedMerge(source, Comparator.naturalOrder(), false, Flowable.bufferSize());
    }

    public static <T extends Comparable<? super T>> Flowable<T> orderedMerge(ParallelFlowable<T> source, boolean delayErrors) {
        return ParallelTransformers.orderedMerge(source, Comparator.naturalOrder(), delayErrors, Flowable.bufferSize());
    }

    public static <T extends Comparable<? super T>> Flowable<T> orderedMerge(ParallelFlowable<T> source, boolean delayErrors, int prefetch) {
        return ParallelTransformers.orderedMerge(source, Comparator.naturalOrder(), delayErrors, prefetch);
    }

    public static <T> Flowable<T> orderedMerge(ParallelFlowable<T> source, Comparator<? super T> comparator) {
        return ParallelTransformers.orderedMerge(source, comparator, false, Flowable.bufferSize());
    }

    public static <T> Flowable<T> orderedMerge(ParallelFlowable<T> source, Comparator<? super T> comparator, boolean delayErrors) {
        return ParallelTransformers.orderedMerge(source, comparator, delayErrors, Flowable.bufferSize());
    }

    public static <T> Flowable<T> orderedMerge(ParallelFlowable<T> source, Comparator<? super T> comparator, boolean delayErrors, int prefetch) {
        Objects.requireNonNull(comparator, "comparator is null");
        Objects.requireNonNull(source, "sources is null");
        ObjectHelper.verifyPositive((int)prefetch, (String)"prefetch");
        return RxJavaPlugins.onAssembly(new ParallelOrderedMerge<T>(source, comparator, delayErrors, prefetch));
    }

    public static <T extends Number> ParallelTransformer<T, Integer> sumInteger() {
        return new ParallelSumInteger(null);
    }

    public static <T extends Number> ParallelTransformer<T, Long> sumLong() {
        return new ParallelSumLong(null);
    }

    public static <T extends Number> ParallelTransformer<T, Double> sumDouble() {
        return new ParallelSumDouble(null);
    }
}

