/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.processors;

import hu.akarnokd.rxjava3.util.SpmcLinkedArrayQueue;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.fuseable.SimplePlainQueue;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class DispatchWorkProcessor<T>
extends FlowableProcessor<T>
implements Disposable {
    final SimplePlainQueue<T> queue;
    final AtomicInteger wip;
    final AtomicReference<Subscription> upstream;
    final AtomicReference<Throwable> error;
    final boolean delayErrors;
    final AtomicReference<WorkDisposable<T>[]> observers;
    final Scheduler scheduler;
    final long prefetch;
    final AtomicLong requestedDownstream;
    final AtomicLong requestedUpstream;
    static final WorkDisposable[] EMPTY = new WorkDisposable[0];
    static final WorkDisposable[] TERMINATED = new WorkDisposable[0];

    public static <T> DispatchWorkProcessor<T> create(Scheduler scheduler) {
        return DispatchWorkProcessor.create(scheduler, Flowable.bufferSize(), true);
    }

    public static <T> DispatchWorkProcessor<T> createUnbounded(Scheduler scheduler) {
        return DispatchWorkProcessor.createUnbounded(scheduler, Flowable.bufferSize(), true);
    }

    public static <T> DispatchWorkProcessor<T> create(Scheduler scheduler, int capacityHint) {
        return DispatchWorkProcessor.create(scheduler, capacityHint, true);
    }

    public static <T> DispatchWorkProcessor<T> create(Scheduler scheduler, boolean delayErrors) {
        return DispatchWorkProcessor.create(scheduler, Flowable.bufferSize(), delayErrors);
    }

    public static <T> DispatchWorkProcessor<T> create(Scheduler scheduler, int capacityHint, boolean delayErrors) {
        return new DispatchWorkProcessor<T>(capacityHint, delayErrors, scheduler, false);
    }

    public static <T> DispatchWorkProcessor<T> createUnbounded(Scheduler scheduler, int capacityHint, boolean delayErrors) {
        return new DispatchWorkProcessor<T>(capacityHint, delayErrors, scheduler, true);
    }

    DispatchWorkProcessor(int capacityHint, boolean delayErrors, Scheduler scheduler, boolean unbounded) {
        this.queue = new SpmcLinkedArrayQueue(capacityHint);
        this.delayErrors = delayErrors;
        this.wip = new AtomicInteger();
        this.upstream = new AtomicReference();
        this.error = new AtomicReference();
        this.observers = new AtomicReference<WorkDisposable[]>(EMPTY);
        this.scheduler = scheduler;
        this.prefetch = unbounded ? Long.MAX_VALUE : (long)capacityHint;
        this.requestedUpstream = new AtomicLong();
        this.requestedDownstream = new AtomicLong();
    }

    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.setOnce(this.upstream, (Subscription)s)) {
            s.request(this.prefetch);
        }
    }

    public void onNext(T t) {
        if (this.error.get() == null) {
            this.queue.offer(t);
            for (WorkDisposable<T> wd : this.observers.get()) {
                wd.drain();
            }
        }
    }

    public void onError(Throwable e) {
        Objects.requireNonNull(e, "e is null");
        if (this.error.compareAndSet(null, e)) {
            for (WorkDisposable wd : this.observers.getAndSet(TERMINATED)) {
                wd.drain();
            }
        } else {
            RxJavaPlugins.onError((Throwable)e);
        }
    }

    public void onComplete() {
        if (this.error.compareAndSet(null, ExceptionHelper.TERMINATED)) {
            for (WorkDisposable wd : this.observers.getAndSet(TERMINATED)) {
                wd.drain();
            }
        }
    }

    protected void subscribeActual(Subscriber<? super T> subscriber) {
        WorkDisposable<T> wd = new WorkDisposable<T>(subscriber, this, this.scheduler.createWorker(), this.delayErrors);
        subscriber.onSubscribe(wd);
        if (this.add(wd) && wd.isCancelled()) {
            this.remove(wd);
            return;
        }
        wd.drain();
    }

    public void dispose() {
        SubscriptionHelper.cancel(this.upstream);
    }

    public boolean isDisposed() {
        return SubscriptionHelper.CANCELLED == this.upstream.get();
    }

    public boolean hasComplete() {
        return this.error.get() == ExceptionHelper.TERMINATED;
    }

    public boolean hasThrowable() {
        Throwable ex = this.error.get();
        return ex != null && ex != ExceptionHelper.TERMINATED;
    }

    public Throwable getThrowable() {
        Throwable ex = this.error.get();
        return ex != ExceptionHelper.TERMINATED ? ex : null;
    }

    public boolean hasSubscribers() {
        return this.observers.get().length != 0;
    }

    boolean add(WorkDisposable<T> wd) {
        WorkDisposable[] b;
        WorkDisposable<T>[] a;
        do {
            if ((a = this.observers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new WorkDisposable[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = wd;
        } while (!this.observers.compareAndSet(a, b));
        return true;
    }

    void remove(WorkDisposable<T> wd) {
        WorkDisposable<T>[] a;
        int n;
        while ((n = (a = this.observers.get()).length) != 0) {
            WorkDisposable[] b;
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != wd) continue;
                j = i;
                break;
            }
            if (j < 0) break;
            if (n == 1) {
                b = EMPTY;
            } else {
                b = new WorkDisposable[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            }
            if (!this.observers.compareAndSet(a, b)) continue;
            break;
        }
    }

    void requestMore(long n) {
        long pf = this.prefetch;
        Subscription s = this.upstream.get();
        if (pf != Long.MAX_VALUE && s != null) {
            long ru;
            long rd;
            long limit = pf - (pf >> 2);
            AtomicLong requestedDownstream = this.requestedDownstream;
            BackpressureHelper.add((AtomicLong)requestedDownstream, (long)n);
            AtomicLong requestedUpstream = this.requestedUpstream;
            while ((rd = requestedDownstream.get()) - (ru = requestedUpstream.get()) >= limit) {
                long next = BackpressureHelper.addCap((long)ru, (long)limit);
                if (!requestedUpstream.compareAndSet(ru, next)) continue;
                s.request(limit);
            }
        }
    }

    static final class WorkDisposable<T>
    extends AtomicInteger
    implements Subscription,
    Runnable {
        private static final long serialVersionUID = 7597704795244221647L;
        final Subscriber<? super T> downstream;
        final DispatchWorkProcessor<T> parent;
        final Scheduler.Worker worker;
        final boolean delayErrors;
        final AtomicLong requested;
        long emitted;
        volatile boolean disposed;

        WorkDisposable(Subscriber<? super T> downstream, DispatchWorkProcessor<T> parent, Scheduler.Worker worker, boolean delayErrors) {
            this.downstream = downstream;
            this.parent = parent;
            this.worker = worker;
            this.delayErrors = delayErrors;
            this.requested = new AtomicLong();
        }

        public void cancel() {
            this.disposed = true;
            this.parent.remove(this);
            this.worker.dispose();
        }

        boolean isCancelled() {
            return this.disposed;
        }

        public void request(long n) {
            BackpressureHelper.add((AtomicLong)this.requested, (long)n);
            this.drain();
        }

        @Override
        public void run() {
            int missed = 1;
            DispatchWorkProcessor<T> parent = this.parent;
            SimplePlainQueue q = parent.queue;
            Subscriber<? super T> downstream = this.downstream;
            AtomicReference<Throwable> error = parent.error;
            boolean delayErrors = this.delayErrors;
            long e = this.emitted;
            AtomicLong requested = this.requested;
            do {
                boolean d;
                Throwable ex;
                long r = requested.get();
                long c = 0L;
                while (e != r) {
                    boolean empty;
                    if (this.disposed) {
                        return;
                    }
                    ex = error.get();
                    boolean bl = d = ex != null;
                    if (d && !delayErrors && ex != ExceptionHelper.TERMINATED) {
                        q.clear();
                        downstream.onError(ex);
                        this.worker.dispose();
                        return;
                    }
                    Object v = q.poll();
                    boolean bl2 = empty = v == null;
                    if (d && empty) {
                        if (ex == ExceptionHelper.TERMINATED) {
                            downstream.onComplete();
                        } else {
                            downstream.onError(ex);
                        }
                        this.worker.dispose();
                        return;
                    }
                    if (empty) break;
                    downstream.onNext(v);
                    ++e;
                    ++c;
                }
                if (c != 0L) {
                    parent.requestMore(c);
                }
                if (e == r) {
                    if (this.disposed) {
                        return;
                    }
                    ex = error.get();
                    boolean bl = d = ex != null;
                    if (d && !delayErrors && ex != ExceptionHelper.TERMINATED) {
                        q.clear();
                        downstream.onError(ex);
                        this.worker.dispose();
                        return;
                    }
                    boolean empty = q.isEmpty();
                    if (d && empty) {
                        if (ex == ExceptionHelper.TERMINATED) {
                            downstream.onComplete();
                        } else {
                            downstream.onError(ex);
                        }
                        this.worker.dispose();
                        return;
                    }
                }
                this.emitted = e;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.worker.schedule((Runnable)this);
            }
        }
    }
}

