/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.schedulers;

import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class BlockingScheduler
extends Scheduler {
    static final Action SHUTDOWN = new Action(){

        public void run() throws Exception {
        }
    };
    static final int SPIN_LIMIT = 64;
    final ConcurrentLinkedQueue<Action> queue = new ConcurrentLinkedQueue();
    final AtomicLong wip;
    final Lock lock = new ReentrantLock();
    final Condition condition = this.lock.newCondition();
    final AtomicBoolean running = new AtomicBoolean();
    final AtomicBoolean shutdown = new AtomicBoolean();
    final Scheduler timedHelper;
    volatile Thread thread;
    static final int READY = 0;
    static final int RUNNING = 1;
    static final int INTERRUPTING = 2;
    static final int INTERRUPTED = 3;
    static final int FINISHED = 4;
    static final int CANCELLED = 5;

    public BlockingScheduler() {
        this.wip = new AtomicLong();
        this.timedHelper = Schedulers.single();
    }

    public void execute() {
        this.execute(Functions.EMPTY_ACTION);
    }

    public void execute(Action action) {
        Objects.requireNonNull(action, "action is null");
        if (!this.running.get() && this.running.compareAndSet(false, true)) {
            this.thread = Thread.currentThread();
            this.queue.offer(action);
            this.wip.getAndIncrement();
            this.drainLoop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drainLoop() {
        AtomicBoolean stop = this.shutdown;
        AtomicLong wip = this.wip;
        block6: while (true) {
            if (stop.get()) {
                this.cancelAll();
                return;
            }
            do {
                Action a;
                if ((a = this.queue.poll()) == SHUTDOWN) {
                    this.cancelAll();
                    return;
                }
                try {
                    a.run();
                }
                catch (Throwable ex) {
                    RxJavaPlugins.onError((Throwable)ex);
                }
            } while (wip.decrementAndGet() != 0L);
            if (wip.get() != 0L || stop.get()) continue;
            this.lock.lock();
            try {
                while (true) {
                    if (wip.get() != 0L || stop.get()) continue block6;
                    this.condition.await();
                }
            }
            catch (InterruptedException interruptedException) {}
            continue;
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
    }

    void cancelAll() {
        Action a;
        ConcurrentLinkedQueue<Action> q = this.queue;
        while ((a = q.poll()) != null) {
            if (!(a instanceof Disposable)) continue;
            ((Disposable)a).dispose();
        }
    }

    public Disposable scheduleDirect(Runnable run, long delay, TimeUnit unit) {
        Objects.requireNonNull(run, "run is null");
        Objects.requireNonNull(unit, "unit is null");
        if (this.shutdown.get()) {
            return Disposable.disposed();
        }
        final BlockingDirectTask task = new BlockingDirectTask(run);
        if (delay == 0L) {
            this.enqueue(task);
            return task;
        }
        SequentialDisposable inner = new SequentialDisposable();
        final SequentialDisposable outer = new SequentialDisposable((Disposable)inner);
        Disposable d = this.timedHelper.scheduleDirect(new Runnable(){

            @Override
            public void run() {
                outer.replace((Disposable)task);
                BlockingScheduler.this.enqueue(task);
            }
        }, delay, unit);
        if (d == Disposable.disposed()) {
            return d;
        }
        inner.replace(d);
        return outer;
    }

    public void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            this.enqueue(SHUTDOWN);
        }
    }

    void enqueue(Action action) {
        this.queue.offer(action);
        if (this.wip.getAndIncrement() == 0L) {
            this.lock.lock();
            try {
                this.condition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public Scheduler.Worker createWorker() {
        return new BlockingWorker();
    }

    final class BlockingWorker
    extends Scheduler.Worker {
        final CompositeDisposable tasks = new CompositeDisposable();

        BlockingWorker() {
        }

        public void dispose() {
            this.tasks.dispose();
        }

        public boolean isDisposed() {
            return this.tasks.isDisposed();
        }

        public Disposable schedule(Runnable run, long delay, TimeUnit unit) {
            Objects.requireNonNull(run, "run is null");
            Objects.requireNonNull(unit, "unit is null");
            if (BlockingScheduler.this.shutdown.get() || this.isDisposed()) {
                return Disposable.disposed();
            }
            final BlockingTask task = new BlockingTask(run);
            this.tasks.add((Disposable)task);
            if (delay == 0L) {
                BlockingScheduler.this.enqueue(task);
                return task;
            }
            SequentialDisposable inner = new SequentialDisposable();
            final SequentialDisposable outer = new SequentialDisposable((Disposable)inner);
            Disposable d = BlockingScheduler.this.timedHelper.scheduleDirect(new Runnable(){

                @Override
                public void run() {
                    outer.replace((Disposable)task);
                    BlockingScheduler.this.enqueue(task);
                }
            }, delay, unit);
            if (d == Disposable.disposed()) {
                return d;
            }
            inner.replace(d);
            return outer;
        }

        final class BlockingTask
        extends AtomicInteger
        implements Action,
        Disposable {
            private static final long serialVersionUID = -9165914884456950194L;
            final Runnable task;

            BlockingTask(Runnable task) {
                this.task = task;
            }

            public void run() throws Exception {
                block8: {
                    try {
                        if (!this.compareAndSet(0, 1)) break block8;
                        try {
                            this.task.run();
                        }
                        finally {
                            this.compareAndSet(1, 4);
                            BlockingWorker.this.tasks.remove((Disposable)this);
                        }
                    }
                    finally {
                        while (this.get() == 2) {
                        }
                        if (this.get() == 3) {
                            Thread.interrupted();
                        }
                    }
                }
            }

            public void dispose() {
                block3: {
                    do {
                        int s;
                        if ((s = this.get()) >= 2) {
                            return;
                        }
                        if (s == 0 && this.compareAndSet(0, 5)) break block3;
                    } while (!this.compareAndSet(1, 2));
                    Thread t = BlockingScheduler.this.thread;
                    if (t != null) {
                        t.interrupt();
                    }
                    this.set(3);
                }
                BlockingWorker.this.tasks.remove((Disposable)this);
            }

            public boolean isDisposed() {
                return this.get() >= 2;
            }
        }
    }

    final class BlockingDirectTask
    extends AtomicInteger
    implements Action,
    Disposable {
        private static final long serialVersionUID = -9165914884456950194L;
        final Runnable task;

        BlockingDirectTask(Runnable task) {
            this.task = task;
        }

        public void run() throws Exception {
            block8: {
                try {
                    if (!this.compareAndSet(0, 1)) break block8;
                    try {
                        this.task.run();
                    }
                    finally {
                        this.compareAndSet(1, 4);
                    }
                }
                finally {
                    while (this.get() == 2) {
                    }
                    if (this.get() == 3) {
                        Thread.interrupted();
                    }
                }
            }
        }

        public void dispose() {
            int s;
            while (!((s = this.get()) >= 2 || s == 0 && this.compareAndSet(0, 5))) {
                if (!this.compareAndSet(1, 2)) continue;
                Thread t = BlockingScheduler.this.thread;
                if (t != null) {
                    t.interrupt();
                }
                this.set(3);
                break;
            }
        }

        public boolean isDisposed() {
            return this.get() >= 2;
        }
    }
}

