/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.schedulers;

import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.disposables.DisposableContainer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.internal.schedulers.RxThreadFactory;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class ParallelScheduler
extends Scheduler {
    static final ScheduledExecutorService[] SHUTDOWN = new ScheduledExecutorService[0];
    static final ScheduledExecutorService REJECTING = Executors.newSingleThreadScheduledExecutor();
    final ThreadFactory factory;
    final int parallelism;
    final boolean tracking;
    final AtomicReference<ScheduledExecutorService[]> pool;
    int n;

    public ParallelScheduler() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public ParallelScheduler(String threadNamePrefix) {
        this(Runtime.getRuntime().availableProcessors(), (ThreadFactory)new RxThreadFactory(threadNamePrefix));
    }

    public ParallelScheduler(int parallelism) {
        this(parallelism, true);
    }

    public ParallelScheduler(int parallelism, boolean tracking) {
        this(parallelism, tracking, 5);
    }

    public ParallelScheduler(int parallelism, boolean tracking, int priority) {
        this(parallelism, tracking, priority, "RxParallelScheduler");
    }

    public ParallelScheduler(int parallelism, boolean tracking, int priority, String threadNamePrefix) {
        this(parallelism, (ThreadFactory)new RxThreadFactory(threadNamePrefix, ParallelScheduler.checkPriority(priority)), tracking);
    }

    static int checkPriority(int priority) {
        if (priority < 1 || priority > 10) {
            throw new IllegalArgumentException("priority out of range");
        }
        return priority;
    }

    public ParallelScheduler(int parallelism, ThreadFactory factory) {
        this(parallelism, factory, true);
    }

    public ParallelScheduler(int parallelism, ThreadFactory factory, boolean tracking) {
        if (parallelism <= 0) {
            throw new IllegalArgumentException("parallelism > 0 required but it was " + parallelism);
        }
        this.parallelism = parallelism;
        this.factory = factory;
        this.tracking = tracking;
        this.pool = new AtomicReference<ScheduledExecutorService[]>(SHUTDOWN);
        this.start();
    }

    public void start() {
        ScheduledExecutorService[] current;
        ScheduledExecutorService[] next = null;
        do {
            if ((current = this.pool.get()) != SHUTDOWN) {
                if (next != null) {
                    for (ScheduledExecutorService exec : next) {
                        exec.shutdownNow();
                    }
                }
                return;
            }
            if (next != null) continue;
            next = new ScheduledExecutorService[this.parallelism];
            for (int i = 0; i < next.length; ++i) {
                next[i] = Executors.newSingleThreadScheduledExecutor(this.factory);
            }
        } while (!this.pool.compareAndSet(current, next));
    }

    /*
     * Unable to fully structure code
     */
    public void shutdown() {
        block0: while (true) {
            if ((current = this.pool.get()) == ParallelScheduler.SHUTDOWN) {
                return;
            }
            if (!this.pool.compareAndSet(current, ParallelScheduler.SHUTDOWN)) continue;
            var2_2 = current;
            var3_3 = var2_2.length;
            var4_4 = 0;
            while (true) {
                if (var4_4 < var3_3) ** break;
                continue block0;
                exec = var2_2[var4_4];
                exec.shutdownNow();
                ++var4_4;
            }
            break;
        }
    }

    ScheduledExecutorService pick() {
        ScheduledExecutorService[] current = this.pool.get();
        if (current.length == 0) {
            return REJECTING;
        }
        int idx = this.n;
        if (idx >= this.parallelism) {
            idx = 0;
        }
        this.n = idx + 1;
        return current[idx];
    }

    public Scheduler.Worker createWorker() {
        if (this.tracking) {
            return new TrackingParallelWorker(this.pick());
        }
        return new NonTrackingParallelWorker(this.pick());
    }

    public Disposable scheduleDirect(Runnable run) {
        ScheduledExecutorService exec = this.pick();
        if (exec == REJECTING) {
            return Disposable.disposed();
        }
        try {
            return Disposable.fromFuture(exec.submit(RxJavaPlugins.onSchedule((Runnable)run)));
        }
        catch (RejectedExecutionException ex) {
            return Disposable.disposed();
        }
    }

    public Disposable scheduleDirect(Runnable run, long delay, TimeUnit unit) {
        ScheduledExecutorService exec = this.pick();
        if (exec == REJECTING) {
            return Disposable.disposed();
        }
        try {
            return Disposable.fromFuture(exec.schedule(RxJavaPlugins.onSchedule((Runnable)run), delay, unit));
        }
        catch (RejectedExecutionException ex) {
            return Disposable.disposed();
        }
    }

    public Disposable schedulePeriodicallyDirect(Runnable run, long initialDelay, long period, TimeUnit unit) {
        ScheduledExecutorService exec = this.pick();
        if (exec == REJECTING) {
            return Disposable.disposed();
        }
        try {
            return Disposable.fromFuture(exec.scheduleAtFixedRate(RxJavaPlugins.onSchedule((Runnable)run), initialDelay, period, unit));
        }
        catch (RejectedExecutionException ex) {
            return Disposable.disposed();
        }
    }

    static {
        REJECTING.shutdownNow();
    }

    static final class TrackingParallelWorker
    extends Scheduler.Worker {
        final ScheduledExecutorService exec;
        final CompositeDisposable tasks;

        TrackingParallelWorker(ScheduledExecutorService exec) {
            this.exec = exec;
            this.tasks = new CompositeDisposable();
        }

        public void dispose() {
            this.tasks.dispose();
        }

        public boolean isDisposed() {
            return this.tasks.isDisposed();
        }

        public Disposable schedule(Runnable run) {
            TrackedAction ta;
            if (!this.isDisposed() && this.tasks.add((Disposable)(ta = new TrackedAction(RxJavaPlugins.onSchedule((Runnable)run), (DisposableContainer)this.tasks)))) {
                try {
                    Future<Object> f = this.exec.submit(ta);
                    ta.setFuture(f);
                    return ta;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
            return Disposable.disposed();
        }

        public Disposable schedule(Runnable run, long delay, TimeUnit unit) {
            TrackedAction ta;
            if (!this.isDisposed() && this.tasks.add((Disposable)(ta = new TrackedAction(RxJavaPlugins.onSchedule((Runnable)run), (DisposableContainer)this.tasks)))) {
                try {
                    ScheduledFuture<Object> f = this.exec.schedule(ta, delay, unit);
                    ta.setFuture(f);
                    return ta;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
            return Disposable.disposed();
        }

        static final class TrackedAction
        extends AtomicReference<DisposableContainer>
        implements Callable<Object>,
        Disposable {
            static final Future<?> FINISHED = new FutureTask<Object>(Functions.EMPTY_RUNNABLE, null);
            static final Future<?> DISPOSED;
            private static final long serialVersionUID = 4949851341419870956L;
            final AtomicReference<Future<?>> future;
            final Runnable actual;

            TrackedAction(Runnable actual, DisposableContainer parent) {
                this.actual = actual;
                this.lazySet(parent);
                this.future = new AtomicReference();
            }

            @Override
            public Object call() {
                try {
                    this.actual.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    RxJavaPlugins.onError((Throwable)ex);
                }
                this.complete();
                return null;
            }

            void complete() {
                Future<?> f;
                DisposableContainer cd = (DisposableContainer)this.get();
                if (cd != null && this.compareAndSet(cd, null)) {
                    cd.delete((Disposable)this);
                }
                while ((f = this.future.get()) != DISPOSED && !this.future.compareAndSet(f, FINISHED)) {
                }
            }

            public void dispose() {
                Future<?> f;
                DisposableContainer cd = this.getAndSet(null);
                if (cd != null) {
                    cd.delete((Disposable)this);
                }
                if ((f = this.future.get()) != FINISHED && f != DISPOSED && (f = this.future.getAndSet(DISPOSED)) != null && f != FINISHED && f != DISPOSED) {
                    f.cancel(true);
                }
            }

            public boolean isDisposed() {
                return this.get() == null;
            }

            void setFuture(Future<?> d) {
                Future<?> f = this.future.get();
                if (f != FINISHED) {
                    if (f == DISPOSED) {
                        d.cancel(true);
                    } else if (!this.future.compareAndSet(f, d) && (f = this.future.get()) == DISPOSED) {
                        d.cancel(true);
                    }
                }
            }

            static {
                FINISHED.cancel(false);
                DISPOSED = new FutureTask<Object>(Functions.EMPTY_RUNNABLE, null);
                DISPOSED.cancel(false);
            }
        }
    }

    static final class NonTrackingParallelWorker
    extends Scheduler.Worker {
        final ScheduledExecutorService exec;
        volatile boolean shutdown;

        NonTrackingParallelWorker(ScheduledExecutorService exec) {
            this.exec = exec;
        }

        public void dispose() {
            this.shutdown = true;
        }

        public boolean isDisposed() {
            return this.shutdown;
        }

        public Disposable schedule(Runnable run) {
            if (!this.shutdown) {
                try {
                    NonTrackingTask ntt = new NonTrackingTask(RxJavaPlugins.onSchedule((Runnable)run));
                    this.exec.submit(ntt);
                    return ntt;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
            return Disposable.disposed();
        }

        public Disposable schedule(Runnable run, long delay, TimeUnit unit) {
            if (!this.shutdown) {
                try {
                    NonTrackingTask ntt = new NonTrackingTask(RxJavaPlugins.onSchedule((Runnable)run));
                    this.exec.schedule(ntt, delay, unit);
                    return ntt;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
            return Disposable.disposed();
        }

        final class NonTrackingTask
        implements Callable<Object>,
        Disposable {
            final Runnable actual;
            volatile boolean disposed;

            NonTrackingTask(Runnable actual) {
                this.actual = actual;
            }

            @Override
            public Object call() throws Exception {
                if (!this.disposed && !NonTrackingParallelWorker.this.shutdown) {
                    try {
                        this.actual.run();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal((Throwable)ex);
                        RxJavaPlugins.onError((Throwable)ex);
                    }
                }
                return null;
            }

            public void dispose() {
                this.disposed = true;
            }

            public boolean isDisposed() {
                return this.disposed;
            }
        }
    }
}

