/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.schedulers;

import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.disposables.DisposableContainer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class SharedScheduler
extends Scheduler {
    final Scheduler.Worker worker;

    public SharedScheduler(Scheduler other) {
        this.worker = other.createWorker();
    }

    public SharedScheduler(Scheduler.Worker worker) {
        this.worker = worker;
    }

    public void shutdown() {
        this.worker.dispose();
    }

    public Disposable scheduleDirect(Runnable run) {
        return this.worker.schedule(run);
    }

    public Disposable scheduleDirect(Runnable run, long delay, TimeUnit unit) {
        return this.worker.schedule(run, delay, unit);
    }

    public Disposable schedulePeriodicallyDirect(Runnable run, long initialDelay, long period, TimeUnit unit) {
        return this.worker.schedulePeriodically(run, initialDelay, period, unit);
    }

    public long now(TimeUnit unit) {
        return this.worker.now(unit);
    }

    public Scheduler.Worker createWorker() {
        return new SharedWorker(this.worker);
    }

    static final class SharedWorker
    extends Scheduler.Worker {
        final Scheduler.Worker worker;
        final CompositeDisposable tasks;

        SharedWorker(Scheduler.Worker worker) {
            this.worker = worker;
            this.tasks = new CompositeDisposable();
        }

        public void dispose() {
            this.tasks.dispose();
        }

        public boolean isDisposed() {
            return this.tasks.isDisposed();
        }

        public Disposable schedule(Runnable run, long delay, TimeUnit unit) {
            if (this.isDisposed() || this.worker.isDisposed()) {
                return Disposable.disposed();
            }
            SharedAction sa = new SharedAction(run, (DisposableContainer)this.tasks);
            this.tasks.add((Disposable)sa);
            Disposable task = delay <= 0L ? this.worker.schedule((Runnable)sa) : this.worker.schedule((Runnable)sa, delay, unit);
            sa.setFuture(task);
            return sa;
        }

        public long now(TimeUnit unit) {
            return this.worker.now(unit);
        }

        static final class SharedAction
        extends AtomicReference<DisposableContainer>
        implements Runnable,
        Disposable {
            private static final long serialVersionUID = 4949851341419870956L;
            final AtomicReference<Disposable> future;
            final Runnable actual;

            SharedAction(Runnable actual, DisposableContainer parent) {
                this.actual = actual;
                this.lazySet(parent);
                this.future = new AtomicReference();
            }

            @Override
            public void run() {
                try {
                    this.actual.run();
                }
                finally {
                    this.complete();
                }
            }

            void complete() {
                Disposable f;
                DisposableContainer cd = (DisposableContainer)this.get();
                if (cd != null && this.compareAndSet(cd, null)) {
                    cd.delete((Disposable)this);
                }
                while ((f = this.future.get()) != DisposableHelper.DISPOSED && !this.future.compareAndSet(f, this)) {
                }
            }

            public void dispose() {
                DisposableContainer cd = this.getAndSet(null);
                if (cd != null) {
                    cd.delete((Disposable)this);
                }
                DisposableHelper.dispose(this.future);
            }

            public boolean isDisposed() {
                return this.get() == null;
            }

            void setFuture(Disposable d) {
                Disposable f = this.future.get();
                if (f != this) {
                    if (f == DisposableHelper.DISPOSED) {
                        d.dispose();
                    } else if (!this.future.compareAndSet(f, d) && (f = this.future.get()) == DisposableHelper.DISPOSED) {
                        d.dispose();
                    }
                }
            }
        }
    }
}

