/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.string;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.fuseable.ConditionalSubscriber;
import io.reactivex.rxjava3.internal.fuseable.SimplePlainQueue;
import io.reactivex.rxjava3.internal.queue.SpscArrayQueue;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FlowableSplit
extends Flowable<String>
implements FlowableTransformer<String, String> {
    final Publisher<String> source;
    final Pattern pattern;
    final int bufferSize;

    FlowableSplit(Publisher<String> source, Pattern pattern, int bufferSize) {
        this.source = source;
        this.pattern = pattern;
        this.bufferSize = bufferSize;
    }

    public Publisher<String> apply(Flowable<String> upstream) {
        return new FlowableSplit((Publisher<String>)upstream, this.pattern, this.bufferSize);
    }

    protected void subscribeActual(Subscriber<? super String> s) {
        this.source.subscribe((Subscriber)new SplitSubscriber(s, this.pattern, this.bufferSize));
    }

    static final class SplitSubscriber
    extends AtomicInteger
    implements ConditionalSubscriber<String>,
    Subscription {
        static final String[] EMPTY = new String[0];
        private static final long serialVersionUID = -5022617259701794064L;
        final Subscriber<? super String> downstream;
        final Pattern pattern;
        final SimplePlainQueue<String[]> queue;
        final AtomicLong requested;
        final int bufferSize;
        final int limit;
        Subscription upstream;
        volatile boolean cancelled;
        String leftOver;
        String[] current;
        int index;
        int produced;
        volatile boolean done;
        Throwable error;
        int empty;

        SplitSubscriber(Subscriber<? super String> downstream, Pattern pattern, int bufferSize) {
            this.downstream = downstream;
            this.pattern = pattern;
            this.bufferSize = bufferSize;
            this.limit = bufferSize - (bufferSize >> 2);
            this.queue = new SpscArrayQueue(bufferSize);
            this.requested = new AtomicLong();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate((long)n)) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                this.drain();
            }
        }

        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            if (this.getAndIncrement() == 0) {
                this.current = null;
                this.queue.clear();
            }
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
                s.request((long)this.bufferSize);
            }
        }

        public void onNext(String t) {
            if (!this.tryOnNext(t)) {
                this.upstream.request(1L);
            }
        }

        public boolean tryOnNext(String t) {
            String[] a;
            String lo = this.leftOver;
            try {
                a = lo == null || lo.isEmpty() ? this.pattern.split(t, -1) : this.pattern.split(lo + t, -1);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.upstream.cancel();
                this.onError(ex);
                return true;
            }
            if (a.length == 0) {
                this.leftOver = null;
                return false;
            }
            if (a.length == 1) {
                this.leftOver = a[0];
                return false;
            }
            this.leftOver = a[a.length - 1];
            this.queue.offer((Object)a);
            this.drain();
            return true;
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)t);
                return;
            }
            String lo = this.leftOver;
            if (lo != null && !lo.isEmpty()) {
                this.leftOver = null;
                this.queue.offer((Object)new String[]{lo, null});
            }
            this.error = t;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            if (!this.done) {
                this.done = true;
                String lo = this.leftOver;
                if (lo != null && !lo.isEmpty()) {
                    this.leftOver = null;
                    this.queue.offer((Object)new String[]{lo, null});
                }
                this.drain();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            SimplePlainQueue<String[]> q = this.queue;
            int missed = 1;
            int consumed = this.produced;
            String[] array = this.current;
            int idx = this.index;
            int emptyCount = this.empty;
            Subscriber<? super String> a = this.downstream;
            do {
                Throwable ex;
                boolean empty;
                boolean d;
                long r = this.requested.get();
                long e = 0L;
                while (e != r) {
                    if (this.cancelled) {
                        this.current = null;
                        q.clear();
                        return;
                    }
                    d = this.done;
                    if (array == null && (array = (String[])q.poll()) != null) {
                        this.current = array;
                        if (++consumed == this.limit) {
                            consumed = 0;
                            this.upstream.request((long)this.limit);
                        }
                    }
                    boolean bl = empty = array == null;
                    if (d && empty) {
                        this.current = null;
                        ex = this.error;
                        if (ex != null) {
                            a.onError(ex);
                        } else {
                            a.onComplete();
                        }
                        return;
                    }
                    if (empty) break;
                    if (array.length == idx + 1) {
                        array = null;
                        this.current = null;
                        idx = 0;
                        continue;
                    }
                    String v = array[idx];
                    if (v.isEmpty()) {
                        ++emptyCount;
                        ++idx;
                        continue;
                    }
                    while (emptyCount != 0 && e != r) {
                        if (this.cancelled) {
                            this.current = null;
                            q.clear();
                            return;
                        }
                        a.onNext((Object)"");
                        ++e;
                        --emptyCount;
                    }
                    if (e == r || emptyCount != 0) continue;
                    a.onNext((Object)v);
                    ++e;
                    ++idx;
                }
                if (e == r) {
                    if (this.cancelled) {
                        this.current = null;
                        q.clear();
                        return;
                    }
                    d = this.done;
                    if (array == null && (array = (String[])q.poll()) != null) {
                        this.current = array;
                        if (++consumed == this.limit) {
                            consumed = 0;
                            this.upstream.request((long)this.limit);
                        }
                    }
                    boolean bl = empty = array == null;
                    if (d && empty) {
                        this.current = null;
                        ex = this.error;
                        if (ex != null) {
                            a.onError(ex);
                        } else {
                            a.onComplete();
                        }
                        return;
                    }
                }
                if (e != 0L) {
                    BackpressureHelper.produced((AtomicLong)this.requested, (long)e);
                }
                this.empty = emptyCount;
                this.produced = consumed;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

