/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.string;

import hu.akarnokd.rxjava3.string.FlowableCharSequence;
import hu.akarnokd.rxjava3.string.FlowableSplit;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.regex.Pattern;

public final class StringFlowable {
    private StringFlowable() {
        throw new IllegalStateException("No instances!");
    }

    public static Flowable<Integer> characters(CharSequence string) {
        Objects.requireNonNull(string, "string is null");
        return RxJavaPlugins.onAssembly((Flowable)new FlowableCharSequence(string));
    }

    public static FlowableTransformer<String, String> split(Pattern pattern) {
        return StringFlowable.split(pattern, Flowable.bufferSize());
    }

    public static FlowableTransformer<String, String> split(Pattern pattern, int bufferSize) {
        Objects.requireNonNull(pattern, "pattern is null");
        ObjectHelper.verifyPositive((int)bufferSize, (String)"bufferSize");
        return new FlowableSplit(null, pattern, bufferSize);
    }

    public static FlowableTransformer<String, String> split(String pattern) {
        return StringFlowable.split(pattern, Flowable.bufferSize());
    }

    public static FlowableTransformer<String, String> split(String pattern, int bufferSize) {
        return StringFlowable.split(Pattern.compile(pattern), bufferSize);
    }
}

