/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.util;

import io.reactivex.rxjava3.internal.fuseable.SimplePlainQueue;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class SpmcLinkedArrayQueue<T>
implements SimplePlainQueue<T> {
    ARA producerArray;
    int producerIndex;
    final AtomicReference<ARA> consumerArray;

    public SpmcLinkedArrayQueue(int capacity) {
        ARA a;
        this.producerArray = a = new ARA(Math.max(2, capacity) + 1);
        this.consumerArray = new AtomicReference<ARA>(a);
    }

    public boolean offer(T value) {
        Objects.requireNonNull(value, "value is null");
        ARA pa = this.producerArray;
        int pi = this.producerIndex;
        if (pi == pa.length() - 1) {
            ARA next;
            this.producerArray = next = new ARA(pa.length());
            next.lazySet(0, value);
            pa.soNext(next);
            pi = 1;
        } else {
            pa.lazySet(pi, value);
            ++pi;
        }
        this.producerIndex = pi;
        return true;
    }

    public boolean offer(T v1, T v2) {
        Objects.requireNonNull(v1, "v1 is null");
        Objects.requireNonNull(v2, "v2 is null");
        ARA pa = this.producerArray;
        int pi = this.producerIndex;
        if (pi == pa.length() - 1) {
            ARA next;
            this.producerArray = next = new ARA(pa.length());
            next.lazySet(0, v1);
            next.lazySet(1, v2);
            pa.soNext(next);
            pi = 2;
        } else {
            pa.lazySet(pi + 1, v2);
            pa.lazySet(pi, v1);
            pi += 2;
        }
        this.producerIndex = pi;
        return true;
    }

    public boolean isEmpty() {
        AtomicReference<ARA> ca = this.consumerArray;
        ARA a = ca.get();
        AtomicInteger index = a.index;
        while (true) {
            int idx;
            if ((idx = index.get()) < a.length() - 1) {
                Object o = a.get(idx);
                if (idx != index.get()) continue;
                return o == null;
            }
            ARA b = a.lvNext();
            if (b == null) break;
            a = b;
            index = b.index;
        }
        return true;
    }

    public void clear() {
        while (this.poll() != null) {
        }
    }

    public T poll() {
        AtomicReference<ARA> ca = this.consumerArray;
        ARA a = ca.get();
        AtomicInteger index = a.index;
        while (true) {
            int idx;
            if ((idx = index.get()) < a.length() - 1) {
                Object o = a.get(idx);
                if (idx != index.get()) continue;
                if (o == null) {
                    return null;
                }
                if (!index.compareAndSet(idx, idx + 1)) continue;
                a.lazySet(idx, null);
                return (T)o;
            }
            ARA b = a.lvNext();
            if (b == null) break;
            ca.compareAndSet(a, b);
            a = ca.get();
            index = a.index;
        }
        return null;
    }

    static final class ARA
    extends AtomicReferenceArray<Object> {
        private static final long serialVersionUID = 5627139329189102514L;
        final AtomicInteger index = new AtomicInteger();

        ARA(int capacity) {
            super(capacity);
        }

        ARA lvNext() {
            return (ARA)this.get(this.length() - 1);
        }

        void soNext(ARA next) {
            this.lazySet(this.length() - 1, next);
        }
    }
}

