/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base;

import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.mapper.IRichMapper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface IBaseDao<E extends IEntity> {
    default public <PK extends Serializable> PK save(E entity) {
        return this.mapper().save(entity);
    }

    default public int save(Collection<E> list) {
        return this.mapper().save(list);
    }

    default public boolean saveOrUpdate(E entity) {
        return this.mapper().saveOrUpdate(entity);
    }

    default public E selectById(Serializable id) {
        Object obj = this.mapper().findById(id);
        return (E)((IEntity)obj);
    }

    default public List<E> selectByIds(Serializable ... ids) {
        return this.mapper().listByIds(Arrays.asList(ids));
    }

    default public List<E> selectByIds(Collection<? extends Serializable> ids) {
        return this.mapper().listByIds(ids);
    }

    default public List<E> selectByMap(Map<String, Object> where) {
        return this.mapper().listByMapAndDefault(where);
    }

    default public boolean existPk(Serializable id) {
        return this.mapper().existPk(id);
    }

    default public boolean updateById(E entity) {
        return this.mapper().updateById(entity) > 0;
    }

    public boolean updateEntityByIds(E ... var1);

    default public boolean updateEntityByIds(Collection<E> entities) {
        return this.updateEntityByIds(entities.toArray(new IEntity[0]));
    }

    public int updateBy(E var1, E var2);

    default public int deleteByEntityIds(Collection<E> entities) {
        return this.mapper().deleteByEntityIds(entities);
    }

    default public int logicDeleteByEntityIds(Collection<E> entities) {
        return this.mapper().logicDeleteByEntityIds(entities);
    }

    default public int deleteByEntityIds(E ... entities) {
        return this.mapper().deleteByEntityIds((IEntity[])entities);
    }

    default public int logicDeleteByEntityIds(E ... entities) {
        return this.mapper().logicDeleteByEntityIds((IEntity[])entities);
    }

    default public int deleteByIds(Collection<? extends Serializable> ids) {
        return this.mapper().deleteByIds(ids);
    }

    default public int logicDeleteByIds(Collection<? extends Serializable> ids) {
        return this.mapper().logicDeleteByIds(ids);
    }

    default public boolean deleteById(Serializable ... ids) {
        int count = this.mapper().deleteById(ids);
        return count > 0;
    }

    default public boolean logicDeleteById(Serializable ... ids) {
        int count = this.mapper().logicDeleteById(ids);
        return count > 0;
    }

    default public int deleteByMap(Map<String, Object> map) {
        return this.mapper().deleteByMapAndDefault(map);
    }

    default public int logicDeleteByMap(Map<String, Object> map) {
        return this.mapper().logicDeleteByMapAndDefault(map);
    }

    public IRichMapper mapper();
}

