/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.crud;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.BaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.BatchCrudImpl;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.crud.IUpdate;
import cn.org.atool.fluent.mybatis.base.crud.IWrapper;
import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.base.entity.IRichEntity;
import cn.org.atool.fluent.mybatis.base.model.FieldType;
import cn.org.atool.fluent.mybatis.base.model.InsertList;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import cn.org.atool.fluent.mybatis.mapper.MapperSql;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.fluent.mybatis.segment.BaseWrapper;
import cn.org.atool.fluent.mybatis.segment.model.WrapperData;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.SqlProviderUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class BaseSqlProvider<E extends IEntity> {
    private static final char[] EW_CONST = "#{ew.".toCharArray();
    private static final String sub = ".wrapperData.parameters.";

    public static String batchCrud(Map map) {
        IWrapper wrapper = SqlProviderUtils.getWrapper(map, "ew");
        if (!(wrapper instanceof BatchCrudImpl)) {
            throw new IllegalArgumentException("the wrapper should be an instance of BatchUpdaterImpl.");
        }
        return ((BatchCrudImpl)wrapper).batchSql();
    }

    public String insertSelect(Map map) {
        String[] fields = (String[])map.get("fields");
        IQuery query = (IQuery)map.get("ew");
        return BaseSqlProvider.buildInsertSelect(this.dbType(), this.dynamic(query), fields, query);
    }

    public static String buildInsertSelect(DbType dbType, String tableName, String[] fields, IQuery query) {
        MybatisUtil.assertNotBlank("tableName", tableName);
        MybatisUtil.assertNotEmpty("fields", fields);
        MybatisUtil.assertNotNull("ew", query);
        String columns = Stream.of(fields).map(dbType::wrap).collect(Collectors.joining(", "));
        String select = query.getWrapperData().getSqlSelect();
        if (If.isBlank(select) || "*".equals(select)) {
            ((BaseQuery)query).select(fields);
        }
        return "INSERT INTO " + tableName + " (" + columns + ") " + query.getWrapperData().getQuerySql();
    }

    public String insert(E entity) {
        return this.buildInsertSql("", entity, false);
    }

    public String insertWithPk(E entity) {
        return this.buildInsertSql("", entity, true);
    }

    public String insertBatch(Map map) {
        MybatisUtil.assertNotEmpty("list", map);
        List entities = (List)SqlProviderUtils.getParas(map, "list");
        return this.insertBatch(entities, false);
    }

    public String insertBatchWithPk(Map map) {
        MybatisUtil.assertNotEmpty("list", map);
        List entities = (List)SqlProviderUtils.getParas(map, "list");
        return this.insertBatch(entities, true);
    }

    private String insertBatch(List<E> entities, boolean withPk) {
        MapperSql sql = new MapperSql();
        String tableName = null;
        for (IEntity entity : entities) {
            this.validateInsertEntity(entity, withPk);
            if (tableName != null) continue;
            tableName = this.dynamic(entity);
        }
        sql.INSERT_INTO(tableName == null ? this.tableName() : tableName);
        sql.INSERT_COLUMNS(this.dbType(), this.allFields(withPk));
        sql.VALUES();
        for (int index = 0; index < entities.size(); ++index) {
            if (index > 0) {
                sql.APPEND(", ");
            }
            sql.INSERT_VALUES(this.insertBatchEntity(index, (IEntity)entities.get(index), withPk));
        }
        return sql.toString();
    }

    private void validateInsertEntity(E entity, boolean withPk) {
        this.setEntityByDefault((IEntity)entity);
        if (withPk) {
            MybatisUtil.isTrue(this.primaryNotNull(entity), "the pk of insert entity can't be null.", new Object[0]);
        } else {
            MybatisUtil.isTrue(this.primaryIsNull(entity), "the pk of insert entity must be null.", new Object[0]);
        }
    }

    protected abstract void insertEntity(InsertList var1, String var2, E var3, boolean var4);

    protected abstract List<String> insertBatchEntity(int var1, E var2, boolean var3);

    protected abstract boolean primaryIsNull(E var1);

    protected abstract boolean primaryNotNull(E var1);

    public String countNoLimit(Map map) {
        WrapperData ew = SqlProviderUtils.getWrapperData(map, "ew");
        if (If.notBlank(ew.getCustomizedSql())) {
            return ew.getCustomizedSql();
        }
        MapperSql sql = new MapperSql();
        sql.COUNT(ew.getTable(), ew);
        sql.WHERE_GROUP_BY(ew);
        return sql.toString();
    }

    public String count(Map map) {
        WrapperData ew = SqlProviderUtils.getWrapperData(map, "ew");
        if (If.notBlank(ew.getCustomizedSql())) {
            return ew.getCustomizedSql();
        }
        MapperSql sql = new MapperSql();
        sql.COUNT(ew.getTable(), ew);
        sql.WHERE_GROUP_ORDER_BY(ew);
        return SqlProviderUtils.byPaged(this.dbType(), ew, sql.toString());
    }

    private String queryByWrapperData(Map map) {
        WrapperData ew = SqlProviderUtils.getWrapperData(map, "ew");
        if (If.notBlank(ew.getCustomizedSql())) {
            return ew.getCustomizedSql();
        }
        MapperSql sql = new MapperSql();
        sql.SELECT(ew.getTable(), ew, this.joiningAllFields());
        sql.WHERE_GROUP_ORDER_BY(ew);
        return SqlProviderUtils.byPaged(this.dbType(), ew, sql.toString());
    }

    public String listEntity(Map map) {
        return this.queryByWrapperData(map);
    }

    public String listMaps(Map map) {
        return this.queryByWrapperData(map);
    }

    public String listObjs(Map map) {
        return this.queryByWrapperData(map);
    }

    public String listByMap(Map map) {
        Map where = (Map)SqlProviderUtils.getParas(map, "cm");
        MybatisUtil.assertNotEmpty("where", where);
        MapperSql sql = new MapperSql();
        sql.SELECT(this.tableName(), this.joiningAllFields());
        sql.WHERE(this.dbType(), "cm", where);
        return sql.toString();
    }

    public String listByIds(Map map) {
        MapperSql sql = new MapperSql();
        Collection ids = (Collection)SqlProviderUtils.getParas(map, "list");
        MybatisUtil.assertNotEmpty("PrimaryKeyList", ids);
        sql.SELECT(this.tableName(), this.joiningAllFields());
        sql.WHERE_PK_IN(this.dbType().wrap(this.idColumn()), ids.size());
        return sql.toString();
    }

    public String findById(Serializable id) {
        MybatisUtil.assertNotNull("PrimaryKey", id);
        MapperSql sql = new MapperSql();
        sql.SELECT(this.tableName(), this.joiningAllFields());
        sql.WHERE(String.format("%s = #{value}", this.dbType().wrap(this.idColumn())));
        return sql.toString();
    }

    private String joiningAllFields() {
        return this.allFields(true).stream().map(this.dbType()::wrap).collect(Collectors.joining(", "));
    }

    public String findOne(Map map) {
        return this.queryByWrapperData(map);
    }

    public String deleteById(Map map) {
        Object[] ids = (Serializable[])map.get("list");
        MybatisUtil.assertNotEmpty("ids", ids);
        MapperSql sql = new MapperSql();
        sql.DELETE_FROM(this.tableName(), null);
        this.whereEqIds(sql, (Serializable[])ids);
        return sql.toString();
    }

    public String logicDeleteById(Map map) {
        Object[] ids = (Serializable[])map.get("list");
        MybatisUtil.assertNotEmpty("ids", ids);
        MapperSql sql = new MapperSql();
        this.logicDelete(sql);
        this.whereEqIds(sql, (Serializable[])ids);
        return sql.toString();
    }

    private void whereEqIds(MapperSql sql, Serializable[] ids) {
        String idColumn = this.dbType().wrap(this.idColumn());
        if (ids.length == 1) {
            sql.WHERE(String.format("%s = #{list[0]}", idColumn));
        } else {
            StringBuilder values = new StringBuilder();
            for (int index = 0; index < ids.length; ++index) {
                if (index > 0) {
                    values.append(", ");
                }
                values.append("#{list[").append(index).append("]}");
            }
            sql.WHERE(String.format("%s IN (%s)", idColumn, values));
        }
    }

    public String deleteByIds(Map map) {
        Collection ids = (Collection)SqlProviderUtils.getParas(map, "list");
        MybatisUtil.assertNotEmpty("ids", ids);
        MapperSql sql = new MapperSql();
        sql.DELETE_FROM(this.tableName(), null);
        sql.WHERE_PK_IN(this.dbType().wrap(this.idColumn()), ids.size());
        return sql.toString();
    }

    public String logicDeleteByIds(Map map) {
        Collection ids = (Collection)SqlProviderUtils.getParas(map, "list");
        MybatisUtil.assertNotEmpty("ids", ids);
        MapperSql sql = new MapperSql();
        this.logicDelete(sql);
        sql.WHERE_PK_IN(this.dbType().wrap(this.idColumn()), ids.size());
        return sql.toString();
    }

    public String deleteByMap(Map<String, Object> map) {
        Map cm = (Map)SqlProviderUtils.getParas(map, "cm");
        MapperSql sql = new MapperSql();
        sql.DELETE_FROM(this.tableName(), null);
        this.whereByMap(sql, cm);
        return sql.toString();
    }

    public String logicDeleteByMap(Map<String, Object> map) {
        Map cm = (Map)SqlProviderUtils.getParas(map, "cm");
        MapperSql sql = new MapperSql();
        this.logicDelete(sql);
        this.whereByMap(sql, cm);
        return sql.toString();
    }

    private void whereByMap(MapperSql sql, Map<String, Object> map) {
        ArrayList<String> where = new ArrayList<String>();
        for (String key : map.keySet()) {
            where.add(String.format("%s = #{%s.%s}", this.dbType().wrap(key), "cm", key));
        }
        sql.WHERE(where);
    }

    public String delete(Map map) {
        WrapperData ew = SqlProviderUtils.getWrapperData(map, "ew");
        return this.buildDeleteSql(ew, false);
    }

    public String logicDelete(Map map) {
        WrapperData ew = SqlProviderUtils.getWrapperData(map, "ew");
        return this.buildDeleteSql(ew, true);
    }

    public String updateBy(Map<String, Object> map) {
        Object wrapper = map.get("ew");
        if (If.isEmpty(wrapper)) {
            throw FluentMybatisException.instance("the parameter[%s] can't be empty.", "ew");
        }
        if (!(wrapper instanceof IUpdate[])) {
            throw new IllegalArgumentException("the parameter should be an array of IUpdate");
        }
        IUpdate[] updaters = (IUpdate[])wrapper;
        ArrayList<String> list = new ArrayList<String>(updaters.length);
        int index = 0;
        for (IUpdate updater : updaters) {
            String sql = this.buildUpdaterSql(updater.getWrapperData());
            sql = BaseSqlProvider.addEwParaIndex(sql, String.format("[%d]", index));
            ++index;
            list.add(sql);
        }
        return String.join((CharSequence)";\n", list);
    }

    static String addEwParaIndex(String sql, String aIndex) {
        StringBuilder buff = new StringBuilder();
        int match = 0;
        int len = sql.length();
        for (int loop = 0; loop < sql.length(); ++loop) {
            char ch = sql.charAt(loop);
            if (match == 4) {
                if (sql.substring(loop, Integer.min(sub.length() + loop, len)).equals(sub)) {
                    buff.append(aIndex);
                }
                match = 0;
            } else {
                match = EW_CONST[match] == ch ? match + 1 : 0;
            }
            buff.append(ch);
        }
        return buff.toString();
    }

    protected abstract void setEntityByDefault(IEntity var1);

    protected abstract List<String> updateDefaults(Map<String, String> var1, boolean var2);

    public String buildInsertSql(String prefix, E entity, boolean withPk) {
        MybatisUtil.assertNotNull("entity", entity);
        this.validateInsertEntity(entity, withPk);
        MapperSql sql = new MapperSql();
        sql.INSERT_INTO(this.dynamic((IEntity)entity));
        InsertList inserts = new InsertList();
        this.insertEntity(inserts, prefix, entity, withPk);
        sql.INSERT_COLUMNS(this.dbType(), inserts.columns);
        sql.VALUES();
        sql.INSERT_VALUES(inserts.values);
        return sql.toString();
    }

    public String buildUpdaterSql(WrapperData ew) {
        MybatisUtil.assertNotNull("wrapperData of updater", ew);
        if (If.notBlank(ew.getCustomizedSql())) {
            return ew.getCustomizedSql();
        }
        Map<String, String> updates = ew.getUpdates();
        MybatisUtil.assertNotEmpty("updates", updates);
        MapperSql sql = new MapperSql();
        sql.UPDATE(ew.getTable(), ew);
        List<String> needDefaults = this.updateDefaults(updates, ew.isIgnoreLockVersion());
        String versionField = this.versionField();
        if (ew.isIgnoreLockVersion() && If.notBlank(versionField)) {
            needDefaults.remove(this.versionField());
        }
        needDefaults.add(ew.getUpdateStr());
        sql.SET(needDefaults);
        if (!ew.isIgnoreLockVersion()) {
            this.checkUpdateVersionWhere(ew.findWhereColumns());
        }
        sql.WHERE_GROUP_ORDER_BY(ew);
        sql.LIMIT(ew, true);
        return sql.toString();
    }

    protected void checkUpdateVersionWhere(List<String> wheres) {
        String versionField = this.versionField();
        if (If.notBlank(versionField) && !wheres.contains(versionField) && !wheres.contains(this.dbType().wrap(versionField))) {
            throw new RuntimeException("The version lock field was explicitly set, but no version condition was found in the update condition.");
        }
    }

    public String buildDeleteSql(WrapperData ew, boolean isLogic) {
        if (If.notBlank(ew.getCustomizedSql())) {
            return ew.getCustomizedSql();
        }
        MapperSql sql = new MapperSql();
        if (isLogic) {
            this.logicDelete(sql);
        } else {
            sql.DELETE_FROM(ew.getTable(), ew);
        }
        sql.WHERE_GROUP_ORDER_BY(ew);
        return sql.toString();
    }

    private void logicDelete(MapperSql sql) {
        MybatisUtil.assertNotNull("logical delete field of table(" + this.tableName() + ")", this.logicDeleteField());
        sql.UPDATE(this.tableName(), null);
        if (this.longTypeOfLogicDelete()) {
            sql.SET(String.format("%s = %d", this.dbType().wrap(this.logicDeleteField()), System.currentTimeMillis()));
        } else {
            sql.SET(String.format("%s = true", this.dbType().wrap(this.logicDeleteField())));
        }
    }

    protected abstract DbType dbType();

    protected abstract String tableName();

    protected abstract List<String> allFields(boolean var1);

    protected abstract IMapping mapping();

    private String idColumn() {
        return this.mapping().findField(FieldType.PRIMARY_ID).map(c -> c.column).orElseThrow(() -> new RuntimeException("the primary not found."));
    }

    private String versionField() {
        return this.mapping().findField(FieldType.LOCK_VERSION).map(c -> c.column).orElse(null);
    }

    private String logicDeleteField() {
        return this.mapping().findField(FieldType.LOGIC_DELETED).map(c -> c.column).orElse(null);
    }

    protected abstract boolean longTypeOfLogicDelete();

    private String dynamic(IEntity entity) {
        if (entity instanceof IRichEntity) {
            String dynamic = entity.findTableBelongTo();
            return If.isBlank(dynamic) ? this.tableName() : dynamic;
        }
        return this.tableName();
    }

    private String dynamic(IQuery query) {
        String table = ((BaseWrapper)((Object)query)).getTable().get();
        return If.isBlank(table) ? this.tableName() : table;
    }

    private String dynamic(IUpdate update) {
        String table = ((BaseWrapper)((Object)update)).getTable().get();
        return If.isBlank(table) ? this.tableName() : table;
    }
}

