/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.mapper;

import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.IBaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.mapper.IEntityMapper;
import cn.org.atool.fluent.mybatis.base.mapper.IWrapperMapper;
import cn.org.atool.fluent.mybatis.base.model.Column;
import cn.org.atool.fluent.mybatis.base.model.ISqlOp;
import cn.org.atool.fluent.mybatis.base.model.SqlOp;
import cn.org.atool.fluent.mybatis.functions.MapFunction;
import cn.org.atool.fluent.mybatis.model.StdPagedList;
import cn.org.atool.fluent.mybatis.model.TagPagedList;
import cn.org.atool.fluent.mybatis.segment.BaseSegment;
import cn.org.atool.fluent.mybatis.segment.BaseWrapper;
import cn.org.atool.fluent.mybatis.utility.PoJoHelper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;

public interface IRichMapper<E extends IEntity>
extends IEntityMapper<E> {
    default public boolean existPk(Serializable id) {
        Object query = ((IWrapperMapper)((Object)this)).query();
        Column pk = Column.column(((IWrapperMapper)((Object)this)).primaryField(), (BaseWrapper)query);
        ((IBaseQuery)((BaseSegment)query.where().apply(pk, (ISqlOp)SqlOp.EQ, id)).end()).limit(1);
        Integer count = this.count((IQuery)query);
        return count != null && count > 0;
    }

    default public boolean saveOrUpdate(E entity) {
        if (entity.findPk() == null) {
            return this.insert(entity) > 0;
        }
        if (this.existPk(entity.findPk())) {
            return this.updateById(entity) > 0;
        }
        return this.insertWithPk(entity) > 0;
    }

    default public <PK extends Serializable> PK save(E entity) {
        if (entity.findPk() == null) {
            this.insert(entity);
        } else {
            this.insertWithPk(entity);
        }
        return (PK)entity.findPk();
    }

    default public int save(Collection<E> list) {
        boolean hasPk = false;
        for (IEntity entity : list) {
            if (entity.findPk() == null) continue;
            hasPk = true;
            break;
        }
        if (hasPk) {
            return this.insertBatchWithPk(list);
        }
        return this.insertBatch(list);
    }

    default public <POJO> Optional<POJO> findOne(IQuery query, MapFunction<POJO> mapFunction) {
        Optional<Map<String, Object>> optional = this.findOneMap(query);
        return optional.map(m -> PoJoHelper.toPoJo(m, mapFunction));
    }

    default public <POJO> Optional<POJO> findOne(Class<POJO> clazz, IQuery query) {
        Optional<Map<String, Object>> optional = this.findOneMap(query);
        return optional.map(m -> PoJoHelper.toPoJo(clazz, m));
    }

    default public Optional<Map<String, Object>> findOneMap(IQuery query) {
        List<Map<String, Object>> list = this.listMaps(query);
        if (list != null && list.size() > 1) {
            throw new RuntimeException("The expected result is one, but the returned result is multiple.");
        }
        Map<String, Object> map = list == null || list.size() == 0 ? null : list.get(0);
        return Optional.ofNullable(map);
    }

    default public <POJO> List<POJO> listPoJos(IQuery query, MapFunction<POJO> mapFunction) {
        List<Map<String, Object>> list = this.listMaps(query);
        return PoJoHelper.toPoJoList(list, mapFunction);
    }

    default public <POJO> List<POJO> listPoJos(Class<POJO> clazz, IQuery query) {
        List<Map<String, Object>> list = this.listMaps(query);
        return PoJoHelper.toPoJoList(clazz, list);
    }

    default public List<E> listByMapAndDefault(Map<String, Object> where) {
        IQuery query = (IQuery)((BaseSegment)((IWrapperMapper)((Object)this)).defaultQuery().where().eqNotNull(where)).end();
        return this.listEntity(query);
    }

    default public StdPagedList<E> stdPagedEntity(IQuery query) {
        int total = this.countNoLimit(query);
        List list = this.listEntity(query);
        return new StdPagedList(total, list);
    }

    default public StdPagedList<Map<String, Object>> stdPagedMap(IQuery query) {
        int total = this.countNoLimit(query);
        List<Map<String, Object>> list = this.listMaps(query);
        return new StdPagedList<Map<String, Object>>(total, list);
    }

    default public <POJO> StdPagedList<POJO> stdPagedPoJo(IQuery query, @NonNull MapFunction<POJO> mapFunction) {
        if (mapFunction == null) {
            throw new NullPointerException("mapFunction is marked non-null but is null");
        }
        StdPagedList<Map<String, Object>> paged = this.stdPagedMap(query);
        if (paged == null || paged.getData() == null) {
            return paged;
        }
        List<POJO> list = PoJoHelper.toPoJoList(paged.getData(), mapFunction);
        return new StdPagedList<POJO>(paged.getTotal(), list);
    }

    default public <POJO> StdPagedList<POJO> stdPagedPoJo(Class<POJO> clazz, IQuery query) {
        StdPagedList<Map<String, Object>> paged = this.stdPagedMap(query);
        List<POJO> list = PoJoHelper.toPoJoList(clazz, paged.getData());
        return new StdPagedList<POJO>(paged.getTotal(), list);
    }

    default public TagPagedList<E> tagPagedEntity(IQuery query) {
        int size = PoJoHelper.validateTagPaged(query);
        query.limit(size + 1);
        List list = this.listEntity(query);
        IEntity next = null;
        if (list.size() > size) {
            next = (IEntity)list.remove(size);
        }
        return new TagPagedList<IEntity>(list, next);
    }

    default public TagPagedList<Map<String, Object>> tagPagedMap(IQuery query) {
        int size = PoJoHelper.validateTagPaged(query);
        query.limit(size + 1);
        List<Map<String, Object>> list = this.listMaps(query);
        Map<String, Object> next = null;
        if (list.size() > size) {
            next = list.remove(size);
        }
        return new TagPagedList<Map<String, Object>>(list, next);
    }

    default public <POJO> TagPagedList<POJO> tagPagedPoJo(IQuery query, MapFunction<POJO> mapFunction) {
        TagPagedList<Map<String, Object>> paged = this.tagPagedMap(query);
        List<POJO> list = PoJoHelper.toPoJoList(paged.getData(), mapFunction);
        POJO next = PoJoHelper.toPoJo(paged.getNext(), mapFunction);
        return new TagPagedList<POJO>(list, next);
    }

    default public <POJO> TagPagedList<POJO> tagPagedPoJo(Class<POJO> clazz, IQuery query) {
        TagPagedList<Map<String, Object>> paged = this.tagPagedMap(query);
        List<POJO> list = PoJoHelper.toPoJoList(clazz, paged.getData());
        POJO next = PoJoHelper.toPoJo(clazz, paged.getNext());
        return new TagPagedList<POJO>(list, next);
    }

    default public int deleteByMapAndDefault(Map<String, Object> where) {
        IQuery query = (IQuery)((BaseSegment)((IWrapperMapper)((Object)this)).defaultQuery().where().eqNotNull(where)).end();
        return this.delete(query);
    }

    default public int logicDeleteByMapAndDefault(Map<String, Object> where) {
        IQuery query = (IQuery)((BaseSegment)((IWrapperMapper)((Object)this)).defaultQuery().where().eqNotNull(where)).end();
        return this.logicDelete(query);
    }

    default public int deleteByEntityIds(Collection<E> entities) {
        List ids = entities.stream().map(IEntity::findPk).collect(Collectors.toList());
        return this.deleteByIds(ids);
    }

    default public int logicDeleteByEntityIds(Collection<E> entities) {
        List ids = entities.stream().map(IEntity::findPk).collect(Collectors.toList());
        return this.logicDeleteByIds(ids);
    }

    default public int deleteByEntityIds(E ... entities) {
        return this.deleteByEntityIds(Arrays.asList(entities));
    }

    default public int logicDeleteByEntityIds(E ... entities) {
        return this.logicDeleteByEntityIds(Arrays.asList(entities));
    }
}

