/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.mapper;

import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.entity.IEntityHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class EntityHelperFactory {
    private static final Map<Class<? extends IEntity>, IEntityHelper> INSTANCES = new HashMap<Class<? extends IEntity>, IEntityHelper>();
    private static final Lock lock = new ReentrantLock(true);

    public static IEntityHelper getInstance(Class<? extends IEntity> clazz) {
        if (INSTANCES.containsKey(clazz)) {
            return INSTANCES.get(clazz);
        }
        try {
            lock.lock();
            if (INSTANCES.containsKey(clazz)) {
                IEntityHelper iEntityHelper = INSTANCES.get(clazz);
                return iEntityHelper;
            }
            Set<ClassLoader> classLoaders = EntityHelperFactory.getClassLoaders(clazz);
            IEntityHelper helper = EntityHelperFactory.loadEntityHelper(clazz, classLoaders);
            INSTANCES.put(clazz, helper);
            IEntityHelper iEntityHelper = helper;
            return iEntityHelper;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected static Set<ClassLoader> getClassLoaders(Class<? extends IEntity> clazz) {
        HashSet<ClassLoader> classLoaders = new HashSet<ClassLoader>(3);
        classLoaders.add(clazz.getClassLoader());
        if (Thread.currentThread().getContextClassLoader() != null) {
            classLoaders.add(Thread.currentThread().getContextClassLoader());
        }
        classLoaders.add(IEntityHelper.class.getClassLoader());
        return classLoaders;
    }

    private static IEntityHelper loadEntityHelper(Class<? extends IEntity> entityClass, Set<ClassLoader> classLoaders) throws ClassNotFoundException {
        String helperName = entityClass.getName() + "Helper";
        for (ClassLoader classLoader : classLoaders) {
            IEntityHelper helper;
            try {
                helper = (IEntityHelper)classLoader.loadClass(helperName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                helper = null;
            }
            if (helper == null) continue;
            return helper;
        }
        throw new ClassNotFoundException("Cannot find entity helper class: " + helperName);
    }
}

