/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.mapper;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.fluent.mybatis.segment.model.HintType;
import cn.org.atool.fluent.mybatis.segment.model.WrapperData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MapperSql {
    private final StringBuilder buffer = new StringBuilder();

    public String toString() {
        return this.buffer.toString().trim();
    }

    public MapperSql SELECT(String table, String columns) {
        this.buffer.append("SELECT ").append(columns).append(" FROM ").append(table);
        return this;
    }

    public MapperSql COUNT(String table, WrapperData data) {
        this.hint(data, HintType.Before_All);
        this.buffer.append("SELECT ");
        this.hint(data, HintType.After_CrudKey);
        this.buffer.append("COUNT(");
        String select = data.getSqlSelect();
        this.buffer.append(If.isBlank(select) || select.contains(",") ? "*" : select.trim());
        this.buffer.append(") FROM ");
        this.hint(data, HintType.Before_Table);
        this.buffer.append(table);
        this.hint(data, HintType.After_Table);
        return this;
    }

    public MapperSql INSERT_INTO(String table) {
        this.buffer.append("INSERT INTO ").append(table);
        return this;
    }

    public MapperSql VALUES() {
        this.buffer.append(" VALUES ");
        return this;
    }

    public MapperSql INSERT_COLUMNS(DbType dbType, List<String> columns) {
        String joining = columns.stream().map(String::trim).map(dbType::wrap).collect(Collectors.joining(", "));
        this.buffer.append("(").append(joining).append(")");
        return this;
    }

    public MapperSql INSERT_VALUES(List<String> values) {
        this.buffer.append("(").append(String.join((CharSequence)", ", values)).append(")");
        return this;
    }

    public MapperSql DELETE_FROM(String table, WrapperData data) {
        this.hint(data, HintType.Before_All);
        this.buffer.append(" DELETE ");
        this.hint(data, HintType.After_CrudKey);
        this.buffer.append(" FROM ");
        this.hint(data, HintType.Before_Table);
        this.buffer.append(table);
        this.hint(data, HintType.After_Table);
        return this;
    }

    public MapperSql UPDATE(String table) {
        return this.UPDATE(table, null);
    }

    public MapperSql UPDATE(String table, WrapperData data) {
        this.hint(data, HintType.Before_All);
        this.buffer.append(" UPDATE ");
        this.hint(data, HintType.After_CrudKey);
        this.hint(data, HintType.Before_Table);
        this.buffer.append(table);
        this.hint(data, HintType.After_Table);
        return this;
    }

    public MapperSql SET(String ... sets) {
        this.buffer.append(" SET ").append(String.join((CharSequence)",\n", sets));
        return this;
    }

    public MapperSql SET(List<String> sets) {
        this.buffer.append(" SET ").append(String.join((CharSequence)",\n", sets));
        return this;
    }

    public MapperSql WHERE(String whereSql) {
        this.buffer.append(" WHERE ").append(whereSql);
        return this;
    }

    public MapperSql WHERE(List<String> where) {
        this.buffer.append(" WHERE ").append(String.join((CharSequence)" AND ", where));
        return this;
    }

    public MapperSql WHERE(DbType dbType, String prefix, Map<String, Object> where) {
        ArrayList<String> ands = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : where.entrySet()) {
            if (entry.getValue() == null) {
                ands.add(dbType.wrap(entry.getKey()) + " IS NULL");
                continue;
            }
            String column = entry.getKey();
            String el = dbType.wrap(column) + " = #{" + (If.isBlank(prefix) ? column : prefix + "." + column) + "}";
            ands.add(el);
        }
        return this.WHERE(ands);
    }

    public MapperSql WHERE_GROUP_BY(WrapperData data) {
        if (If.notBlank(data.getWhereSql())) {
            this.WHERE(data.getWhereSql());
        }
        if (If.notBlank(data.getGroupBy())) {
            this.APPEND(data.getGroupBy());
        }
        if (If.notBlank(data.getLastSql())) {
            this.APPEND(data.getLastSql());
        }
        return this;
    }

    public MapperSql WHERE_GROUP_ORDER_BY(WrapperData data) {
        if (If.notBlank(data.getWhereSql())) {
            this.WHERE(data.getWhereSql());
        }
        if (If.notBlank(data.getGroupBy())) {
            this.APPEND(data.getGroupBy());
        }
        if (If.notBlank(data.getOrderBy())) {
            this.APPEND(data.getOrderBy());
        }
        if (If.notBlank(data.getLastSql())) {
            this.APPEND(data.getLastSql());
        }
        return this;
    }

    public MapperSql WHERE_PK_IN(String column, int size) {
        this.buffer.append(" WHERE ").append(column).append(" IN (");
        for (int index = 0; index < size; ++index) {
            if (index > 0) {
                this.buffer.append(", ");
            }
            this.buffer.append("#{list[").append(index).append("]}");
        }
        this.buffer.append(")");
        return this;
    }

    public MapperSql APPEND(String sql) {
        this.buffer.append(" ").append(sql).append(" ");
        return this;
    }

    public MapperSql SELECT(String table, WrapperData data, String defaultColumns) {
        this.hint(data, HintType.Before_All);
        this.buffer.append("SELECT ");
        this.hint(data, HintType.After_CrudKey);
        this.APPEND(data.isDistinct() ? "DISTINCT " : " ");
        this.buffer.append(If.isBlank(data.getSqlSelect()) ? defaultColumns : data.getSqlSelect());
        this.buffer.append(" FROM ");
        this.hint(data, HintType.Before_Table);
        this.buffer.append(table);
        this.hint(data, HintType.After_Table);
        return this;
    }

    public MapperSql LIMIT(WrapperData data, boolean offsetEverZero) {
        if (data == null || data.getPaged() == null) {
            return this;
        }
        if (offsetEverZero) {
            this.APPEND(" LIMIT #{ew.wrapperData.paged.limit}");
        } else {
            this.APPEND(" LIMIT #{ew.wrapperData.paged.offset}, #{ew.wrapperData.paged.limit}");
        }
        return this;
    }

    private void hint(WrapperData data, HintType hintType) {
        if (data != null) {
            this.buffer.append(data.hint(hintType));
        }
    }
}

