/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.metadata;

import cn.org.atool.fluent.mybatis.metadata.feature.DbFeature;
import cn.org.atool.fluent.mybatis.metadata.feature.EscapeExpress;
import cn.org.atool.fluent.mybatis.metadata.feature.PagedFormat;

public enum DbType {
    MYSQL("mysql", EscapeExpress.BACK_ESCAPE, PagedFormat.MYSQL_LIMIT, "SELECT LAST_INSERT_ID() AS ID"),
    MARIADB("mariadb", EscapeExpress.BACK_ESCAPE, PagedFormat.MYSQL_LIMIT, "SELECT LAST_INSERT_ID() AS ID"),
    H2("h2", EscapeExpress.BACK_ESCAPE, PagedFormat.MYSQL_LIMIT),
    SQLITE("sqlite", EscapeExpress.D_QUOTATION_ESCAPE, PagedFormat.MYSQL_LIMIT),
    ORACLE("oracle", EscapeExpress.NONE_ESCAPE, PagedFormat.ORACLE_LIMIT, "select SEQ_USER_ID.nextval as id from dual", true),
    DB2("db2", PagedFormat.DB2_LIMIT),
    HSQL("hsql", PagedFormat.PG_LIMIT),
    POSTGRE_SQL("postgresql", EscapeExpress.D_QUOTATION_ESCAPE, PagedFormat.PG_LIMIT),
    SQL_SERVER2005("sqlserver2005", EscapeExpress.SQUARE_BRACKETS_ESCAPE, PagedFormat.UN_SUPPORT_LIMIT),
    SQL_SERVER("sqlserver", EscapeExpress.SQUARE_BRACKETS_ESCAPE, PagedFormat.UN_SUPPORT_LIMIT),
    OTHER("other", PagedFormat.MYSQL_LIMIT),
    OTHER_2("other2", PagedFormat.MYSQL_LIMIT);

    public final DbFeature feature;

    private DbType(String alias, PagedFormat paged) {
        this.feature = new DbFeature(alias, paged);
    }

    private DbType(String alias, EscapeExpress escape, PagedFormat paged) {
        this.feature = new DbFeature(alias, escape, paged);
    }

    private DbType(String alias, EscapeExpress escape, PagedFormat paged, String seq) {
        this.feature = new DbFeature(alias, escape, paged, seq);
    }

    private DbType(String alias, EscapeExpress escape, PagedFormat paged, String seq, boolean before) {
        this.feature = new DbFeature(alias, escape, paged, seq).setBefore(before);
    }

    public String wrap(String column) {
        return this.feature.getEscape().wrap(column);
    }

    public String unwrap(String column) {
        return this.feature.getEscape().unwrap(column);
    }

    public String paged(String query, String pagedOffset, String pagedSize, String pagedEndOffset) {
        return this.feature.getPaged().build(query, pagedOffset, pagedSize, pagedEndOffset);
    }

    public void setEscapeExpress(String expression) {
        this.feature.setEscape(new EscapeExpress(expression));
    }

    public void setPagedFormat(String pagedFormat) {
        this.feature.setPaged(new PagedFormat(pagedFormat));
    }

    public String getPagedFormat() {
        return this.feature.getPaged().getFormat();
    }

    public DbFeature getFeature() {
        return this.feature;
    }
}

