/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.metadata.feature;

import cn.org.atool.fluent.mybatis.If;

public class EscapeExpress {
    private final String prefix;
    private final String suffix;
    public static final EscapeExpress NONE_ESCAPE = new EscapeExpress("?");
    public static final EscapeExpress BACK_ESCAPE = new EscapeExpress("`?`");
    public static final EscapeExpress D_QUOTATION_ESCAPE = new EscapeExpress("\"?\"");
    public static final EscapeExpress S_QUOTATION_ESCAPE = new EscapeExpress("'?'");
    public static final EscapeExpress SQUARE_BRACKETS_ESCAPE = new EscapeExpress("[?]");

    public EscapeExpress(String wrapper) {
        int index = wrapper.indexOf(63);
        if (index < 0) {
            throw new IllegalArgumentException("illegal antisense expression:" + wrapper);
        }
        this.prefix = wrapper.substring(0, index);
        this.suffix = wrapper.substring(index + 1);
    }

    public String wrap(String column) {
        if (If.notBlank(this.prefix) && If.notBlank(this.suffix)) {
            return this.prefix + column + this.suffix;
        }
        return column;
    }

    public String unwrap(String column) {
        int len = column.length();
        if (If.notBlank(this.prefix) && If.notBlank(this.suffix) && column.startsWith(this.prefix) && column.endsWith(this.suffix)) {
            return column.substring(this.prefix.length(), len - this.suffix.length());
        }
        return column;
    }
}

