/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.metadata.feature;

import cn.org.atool.fluent.mybatis.If;

public final class PagedFormat {
    private final String format;
    public static final PagedFormat UN_SUPPORT_LIMIT = new PagedFormat(null);
    public static final PagedFormat MYSQL_LIMIT = new PagedFormat("{query} LIMIT {offset}, {size}");
    public static final PagedFormat PG_LIMIT = new PagedFormat("{query} LIMIT {size} OFFSET {offset}");
    public static final PagedFormat DB2_LIMIT = new PagedFormat("SELECT * FROM (SELECT TMP_PAGE.*,ROWNUMBER() OVER() AS ROW_ID FROM ({query})) AS TMP_PAGE) TMP_PAGE WHERE ROW_ID BETWEEN {offset} AND {size}");
    public static final PagedFormat ORACLE_LIMIT = new PagedFormat("SELECT * FROM (  SELECT TMP_PAGE.*, ROWNUM ROW_ID FROM ({query}) TMP_PAGE)  WHERE ROW_ID > {offset} AND ROW_ID <= {end}");

    public PagedFormat(String format) {
        this.format = format;
    }

    public String build(String query, String pagedOffset, String pagedSize, String pagedEndOffset) {
        if (If.isBlank(this.format)) {
            throw new RuntimeException("not support");
        }
        return this.format.replace("{end}", pagedEndOffset).replace("{size}", pagedSize).replace("{offset}", pagedOffset).replace("{query}", query);
    }

    public String getFormat() {
        return this.format;
    }
}

