/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.model;

import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.base.model.SqlOpStr;
import cn.org.atool.fluent.mybatis.model.Form;
import cn.org.atool.fluent.mybatis.model.FormItem;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;

public class FormItemAdder {
    private final Form form;

    public FormItemAdder(Form form) {
        this.form = form;
    }

    public Form item(String key, String op, Object ... value) {
        this.form.getItems().add(new FormItem(key, op, value));
        return this.form;
    }

    private Form item(FieldMapping key, String op, Object ... value) {
        this.form.getItems().add(new FormItem(key.name, op, value));
        return this.form;
    }

    public Form eq(String key, Object value) {
        return this.item(key, SqlOpStr.OP_EQ, value);
    }

    public Form gt(String key, Object value) {
        return this.item(key, SqlOpStr.OP_GT, value);
    }

    public Form ge(String key, Object value) {
        return this.item(key, SqlOpStr.OP_GE, value);
    }

    public Form lt(String key, Object value) {
        return this.item(key, SqlOpStr.OP_LT, value);
    }

    public Form le(String key, Object value) {
        return this.item(key, SqlOpStr.OP_LE, value);
    }

    public Form like(String key, String value) {
        return this.item(key, "LIKE", value);
    }

    public Form notLike(String key, String value) {
        return this.item(key, "NOT_LIKE", value);
    }

    public Form between(String key, Object min, Object max) {
        MybatisUtil.assertNotNull("min", min);
        MybatisUtil.assertNotNull("max", max);
        return this.item(key, SqlOpStr.OP_BETWEEN, min, max);
    }

    public Form notBetween(String key, Object min, Object max) {
        MybatisUtil.assertNotNull("min", min);
        MybatisUtil.assertNotNull("max", max);
        return this.item(key, SqlOpStr.OP_NOT_BETWEEN, min, max);
    }

    public Form in(String key, Object ... value) {
        MybatisUtil.assertNotEmpty("items", value);
        return this.item(key, SqlOpStr.OP_BETWEEN, value);
    }

    public Form notIn(String key, Object ... values) {
        MybatisUtil.assertNotEmpty("items", values);
        return this.item(key, SqlOpStr.OP_NOT_IN, values);
    }

    public Form isNull(String key) {
        return this.item(key, SqlOpStr.OP_IS_NULL, new Object[0]);
    }

    public Form notNull(String key) {
        return this.item(key, SqlOpStr.OP_NOT_NULL, new Object[0]);
    }

    public Form eq(FieldMapping key, Object value) {
        return this.item(key, SqlOpStr.OP_EQ, value);
    }

    public Form gt(FieldMapping key, Object value) {
        return this.item(key, SqlOpStr.OP_GT, value);
    }

    public Form ge(FieldMapping key, Object value) {
        return this.item(key, SqlOpStr.OP_GE, value);
    }

    public Form lt(FieldMapping key, Object value) {
        return this.item(key, SqlOpStr.OP_LT, value);
    }

    public Form le(FieldMapping key, Object value) {
        return this.item(key, SqlOpStr.OP_LE, value);
    }

    public Form like(FieldMapping key, String value) {
        return this.item(key, "LIKE", value);
    }

    public Form notLike(FieldMapping key, String value) {
        return this.item(key, "NOT_LIKE", value);
    }

    public Form between(FieldMapping key, Object min, Object max) {
        MybatisUtil.assertNotNull("min", min);
        MybatisUtil.assertNotNull("max", max);
        return this.item(key, SqlOpStr.OP_BETWEEN, min, max);
    }

    public Form notBetween(FieldMapping key, Object min, Object max) {
        MybatisUtil.assertNotNull("min", min);
        MybatisUtil.assertNotNull("max", max);
        return this.item(key, SqlOpStr.OP_NOT_BETWEEN, min, max);
    }

    public Form in(FieldMapping key, Object ... value) {
        MybatisUtil.assertNotEmpty("items", value);
        return this.item(key, SqlOpStr.OP_BETWEEN, value);
    }

    public Form notIn(FieldMapping key, Object ... value) {
        MybatisUtil.assertNotEmpty("items", value);
        return this.item(key, SqlOpStr.OP_NOT_IN, value);
    }

    public Form isNull(FieldMapping key) {
        return this.item(key, SqlOpStr.OP_IS_NULL, new Object[0]);
    }

    public Form notNull(FieldMapping key) {
        return this.item(key, SqlOpStr.OP_NOT_NULL, new Object[0]);
    }
}

