/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.IBaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.IWrapper;
import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.base.model.Column;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.base.model.FieldType;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.fluent.mybatis.metadata.TableMeta;
import cn.org.atool.fluent.mybatis.metadata.TableMetaHelper;
import cn.org.atool.fluent.mybatis.segment.model.Parameters;
import cn.org.atool.fluent.mybatis.segment.model.WrapperData;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public abstract class BaseWrapper<E extends IEntity, W extends IWrapper<E, W, NQ>, NQ extends IBaseQuery<E, NQ>>
implements IWrapper<E, W, NQ> {
    private static final long serialVersionUID = 2674302532927710150L;
    protected Supplier<String> table;
    protected String tableAlias;
    protected WrapperData wrapperData;

    protected BaseWrapper(String tableAlias) {
        this.tableAlias = tableAlias;
    }

    protected BaseWrapper(Supplier<String> table, String tableAlias, Class<E> entityClass, Class queryClass) {
        this(table, tableAlias, new Parameters(), entityClass, queryClass);
    }

    protected BaseWrapper(Supplier<String> table, String tableAlias, Parameters parameters, Class<E> entityClass, Class queryClass) {
        MybatisUtil.notNull(entityClass, "entityClass must not null,please set entity before use this method!", new Object[0]);
        this.table = table;
        this.tableAlias = If.isBlank(tableAlias) ? "" : tableAlias.trim();
        this.wrapperData = new WrapperData(table, this.tableAlias, parameters, entityClass, queryClass);
    }

    protected IMapping mapping() {
        return null;
    }

    public String fieldName(FieldType type) {
        IMapping mapping = this.mapping();
        if (mapping == null) {
            return null;
        }
        return mapping.findField(type).map(c -> c.column).orElse(null);
    }

    protected abstract List<String> allFields();

    protected TableMeta getTableMeta() {
        return TableMetaHelper.getTableInfo(this.getWrapperData().getEntityClass());
    }

    protected String appendAlias(String column) {
        return Column.column(column, this).wrapColumn();
    }

    protected void sharedParameter(Parameters parameters) {
        this.wrapperData.getParameters().sharedParameter(parameters);
    }

    protected void sharedParameter(BaseWrapper wrapper) {
        this.wrapperData.getParameters().sharedParameter(wrapper.getWrapperData().getParameters());
    }

    public FieldMapping column(String column) {
        return this.column2mapping().get(column);
    }

    public abstract DbType dbType();

    protected Map<String, FieldMapping> column2mapping() {
        return new HashMap<String, FieldMapping>();
    }

    public Supplier<String> getTable() {
        return this.table;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    @Override
    public WrapperData getWrapperData() {
        return this.wrapperData;
    }
}

