/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment;

import cn.org.atool.fluent.mybatis.base.crud.BaseQuery;
import cn.org.atool.fluent.mybatis.metadata.JoinType;
import cn.org.atool.fluent.mybatis.segment.WhereApply;
import cn.org.atool.fluent.mybatis.segment.where.BaseWhere;
import java.util.ArrayList;
import java.util.List;

public class JoinOnBuilder<QL extends BaseQuery<?, QL>, QR extends BaseQuery<?, QR>> {
    private final BaseQuery<?, QL> queryLeft;
    private final BaseQuery<?, QR> queryRight;
    private final JoinType joinType;
    private final List<String> ons = new ArrayList<String>();

    public JoinOnBuilder(BaseQuery<?, QL> queryLeft, JoinType joinType, BaseQuery<?, QR> queryRight) {
        this.queryLeft = queryLeft;
        this.queryRight = queryRight;
        this.joinType = joinType;
    }

    public JoinOnBuilder<QL, QR> on(BaseWhere<?, QL> left, BaseWhere<?, QR> right) {
        return this.on(((WhereApply)left).current().column, ((WhereApply)right).current().column);
    }

    public JoinOnBuilder<QL, QR> on(String leftValue, String rightValue) {
        this.ons.add(this.queryLeft.appendAlias(leftValue) + " = " + this.queryRight.appendAlias(rightValue));
        return this;
    }

    public JoinOnBuilder<QL, QR> on(String condition) {
        this.ons.add(condition.trim());
        return this;
    }

    public String table() {
        String joinTable = String.format("%s %s", this.joinType.join(), this.queryRight.wrapperData.getTable());
        if (this.ons.isEmpty()) {
            return joinTable;
        }
        return joinTable + " ON " + String.join((CharSequence)" AND ", this.ons);
    }
}

