/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment;

import cn.org.atool.fluent.mybatis.base.crud.BaseQuery;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.segment.GroupBySegmentList;
import cn.org.atool.fluent.mybatis.segment.HavingSegmentList;
import cn.org.atool.fluent.mybatis.segment.OrderBySegmentList;
import cn.org.atool.fluent.mybatis.segment.model.ISqlSegment;
import cn.org.atool.fluent.mybatis.segment.model.KeyWordSegment;
import cn.org.atool.fluent.mybatis.segment.model.Parameters;
import cn.org.atool.fluent.mybatis.segment.model.WrapperData;
import java.util.ArrayList;
import java.util.List;

public class JoinWrapperData
extends WrapperData {
    private final BaseQuery query;
    private final List<BaseQuery> queries;
    private final Parameters parameters;
    private final List<String> tables = new ArrayList<String>();
    private boolean selectMerged = false;
    private boolean whereMerged = false;
    private boolean groupByMerged = false;
    private boolean orderByMerged = false;

    public JoinWrapperData(BaseQuery query, List<BaseQuery> queries, Parameters shared) {
        this.query = query;
        this.queries = queries;
        this.parameters = shared;
        this.tables.add(this.query.wrapperData.getTable());
    }

    public void addTable(String table) {
        this.tables.add(table);
    }

    @Override
    public String getTable() {
        return String.join((CharSequence)" ", this.tables);
    }

    @Override
    public String getSqlSelect() {
        if (this.selectMerged) {
            return super.getSqlSelect();
        }
        this.sqlSelect.addAll(this.query.wrapperData.sqlSelect());
        for (BaseQuery query : this.queries) {
            this.sqlSelect.addAll(query.wrapperData.sqlSelect());
        }
        if (this.sqlSelect.isEmpty()) {
            this.query.allFields().forEach(c -> this.sqlSelect.add(FieldMapping.alias(this.query.tableAlias, (String)c)));
            for (BaseQuery query : this.queries) {
                query.allFields().forEach(c -> this.sqlSelect.add(FieldMapping.alias(query.tableAlias, (String)c)));
            }
        }
        this.selectMerged = true;
        return super.getSqlSelect();
    }

    @Override
    public String getWhereSql() {
        if (this.whereMerged) {
            return super.getWhereSql();
        }
        this.mergeSegments.getWhere().add(KeyWordSegment.AND, this.query.wrapperData.whereSegments());
        for (BaseQuery query : this.queries) {
            this.mergeSegments.getWhere().add(KeyWordSegment.AND, query.wrapperData.whereSegments());
        }
        this.whereMerged = true;
        return super.getWhereSql();
    }

    @Override
    public String getGroupBy() {
        if (this.groupByMerged) {
            return super.getGroupBy();
        }
        this.query.wrapperData.getMergeSegments().getGroupBy().getSegments().forEach(arg_0 -> JoinWrapperData.lambda$getGroupBy$2(this.mergeSegments.getGroupBy(), arg_0));
        this.query.wrapperData.getMergeSegments().getHaving().getSegments().forEach(arg_0 -> JoinWrapperData.lambda$getGroupBy$3(this.mergeSegments.getHaving(), arg_0));
        for (BaseQuery query : this.queries) {
            query.wrapperData.getMergeSegments().getGroupBy().getSegments().forEach(arg_0 -> JoinWrapperData.lambda$getGroupBy$4(this.mergeSegments.getGroupBy(), arg_0));
            if (!this.mergeSegments.getHaving().isEmpty() && !query.wrapperData.getMergeSegments().getHaving().getSegments().isEmpty()) {
                this.mergeSegments.getHaving().addAll(KeyWordSegment.AND);
            }
            query.wrapperData.getMergeSegments().getHaving().getSegments().forEach(arg_0 -> JoinWrapperData.lambda$getGroupBy$5(this.mergeSegments.getHaving(), arg_0));
        }
        this.groupByMerged = true;
        return super.getGroupBy();
    }

    @Override
    public String getOrderBy() {
        if (this.orderByMerged) {
            return super.getOrderBy();
        }
        this.query.wrapperData.getMergeSegments().getOrderBy().getSegments().forEach(arg_0 -> JoinWrapperData.lambda$getOrderBy$6(this.mergeSegments.getOrderBy(), arg_0));
        for (BaseQuery query : this.queries) {
            query.wrapperData.getMergeSegments().getOrderBy().getSegments().forEach(arg_0 -> JoinWrapperData.lambda$getOrderBy$7(this.mergeSegments.getOrderBy(), arg_0));
        }
        this.orderByMerged = true;
        return super.getOrderBy();
    }

    @Override
    public String getUpdateStr() {
        throw new RuntimeException("not support!");
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    private static /* synthetic */ void lambda$getOrderBy$7(OrderBySegmentList rec$, ISqlSegment xva$0) {
        rec$.addAll(xva$0);
    }

    private static /* synthetic */ void lambda$getOrderBy$6(OrderBySegmentList rec$, ISqlSegment xva$0) {
        rec$.addAll(xva$0);
    }

    private static /* synthetic */ void lambda$getGroupBy$5(HavingSegmentList rec$, ISqlSegment xva$0) {
        rec$.addAll(xva$0);
    }

    private static /* synthetic */ void lambda$getGroupBy$4(GroupBySegmentList rec$, ISqlSegment xva$0) {
        rec$.addAll(xva$0);
    }

    private static /* synthetic */ void lambda$getGroupBy$3(HavingSegmentList rec$, ISqlSegment xva$0) {
        rec$.addAll(xva$0);
    }

    private static /* synthetic */ void lambda$getGroupBy$2(GroupBySegmentList rec$, ISqlSegment xva$0) {
        rec$.addAll(xva$0);
    }
}

