/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment;

import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.IRefs;
import cn.org.atool.fluent.mybatis.base.crud.IBaseUpdate;
import cn.org.atool.fluent.mybatis.base.model.Column;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.functions.GetterFunc;
import cn.org.atool.fluent.mybatis.segment.BaseSegment;
import cn.org.atool.fluent.mybatis.segment.UpdateApply;
import cn.org.atool.fluent.mybatis.utility.MappingKits;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.util.Arrays;
import java.util.Map;

public abstract class UpdateBase<S extends UpdateBase<S, U>, U extends IBaseUpdate<?, U, ?>>
extends BaseSegment<UpdateApply<S, U>, U> {
    private final UpdateApply<S, U> apply = new UpdateApply(this);
    public final S set = this;

    protected UpdateBase(U updater) {
        super(updater);
    }

    public S byNotNull(Map<String, Object> values) {
        if (values != null) {
            values.forEach((column, value) -> {
                Column _column = Column.column(column, this.wrapper);
                this.wrapperData().updateSet(_column, value);
            });
        }
        return (S)this;
    }

    public S byEntity(IEntity entity, FieldMapping column, FieldMapping ... columns) {
        MybatisUtil.assertNotNull("entity", entity);
        String[] arr = MappingKits.toColumns(column, columns);
        return this.byEntity(entity, arr);
    }

    public <E extends IEntity> S byEntity(E entity, GetterFunc<E> getter, GetterFunc<E> ... getters) {
        MybatisUtil.assertNotNull("entity", entity);
        Class<? extends IEntity> klass = IRefs.instance().findFluentEntityClass(entity.getClass());
        String[] arr = MappingKits.toColumns(klass, getter, getters);
        return this.byEntity(entity, arr);
    }

    public S byEntity(IEntity entity, String ... columns) {
        super.byEntity(entity, (String column, Object value) -> {
            Column _column = Column.column(column, this.wrapper);
            this.wrapperData().updateSet(_column, value);
        }, false, Arrays.asList(columns));
        return (S)this;
    }

    public S byExclude(IEntity entity, FieldMapping exclude, FieldMapping ... excludes) {
        MybatisUtil.assertNotNull("entity", entity);
        String[] arr = MappingKits.toColumns(exclude, excludes);
        return this.byExclude(entity, arr);
    }

    public <E extends IEntity> S byExclude(E entity, GetterFunc<E> exclude, GetterFunc<E> ... excludes) {
        MybatisUtil.assertNotNull("entity", entity);
        Class<? extends IEntity> klass = IRefs.instance().findFluentEntityClass(entity.getClass());
        String[] arr = MappingKits.toColumns(klass, exclude, excludes);
        return this.byExclude(entity, arr);
    }

    public S byExclude(IEntity entity, String ... excludes) {
        super.byExclude(entity, (String column, Object value) -> {
            Column _column = Column.column(column, this.wrapper);
            this.wrapperData().updateSet(_column, value);
        }, false, Arrays.asList(excludes));
        return (S)this;
    }

    @Override
    protected UpdateApply<S, U> apply() {
        return this.apply;
    }
}

