/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment.model;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.model.Column;
import cn.org.atool.fluent.mybatis.base.model.ISqlOp;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import cn.org.atool.fluent.mybatis.segment.WhereSegmentList;
import cn.org.atool.fluent.mybatis.segment.model.ColumnSegment;
import cn.org.atool.fluent.mybatis.segment.model.HintType;
import cn.org.atool.fluent.mybatis.segment.model.ISqlSegment;
import cn.org.atool.fluent.mybatis.segment.model.IWrapperData;
import cn.org.atool.fluent.mybatis.segment.model.KeyWordSegment;
import cn.org.atool.fluent.mybatis.segment.model.MergeSegments;
import cn.org.atool.fluent.mybatis.segment.model.PagedOffset;
import cn.org.atool.fluent.mybatis.segment.model.Parameters;
import cn.org.atool.fluent.mybatis.utility.CustomizedSql;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class WrapperData
implements IWrapperData {
    protected boolean isDistinct = false;
    protected List<String> sqlSelect = new ArrayList<String>(8);
    protected Supplier<String> table;
    private String alias;
    protected final Parameters parameters;
    protected final MergeSegments mergeSegments = new MergeSegments();
    protected PagedOffset paged;
    private final Map<String, String> updates = new LinkedHashMap<String, String>(16);
    private final Map<HintType, String> hints = new HashMap<HintType, String>(4);
    private final Class entityClass;
    private final Class queryClass;
    private final Set<String> fieldAlias = new HashSet<String>();
    private boolean ignoreLockVersion = false;
    private String customizedSql = null;

    public WrapperData() {
        this.parameters = new Parameters();
        this.queryClass = null;
        this.entityClass = null;
    }

    public WrapperData(Supplier<String> table, String alias, Parameters parameters, Class entityClass, Class queryClass) {
        MybatisUtil.notNull(entityClass, "entityClass must not null,please set entity before use this method!", new Object[0]);
        this.table = table;
        this.alias = alias;
        this.parameters = parameters;
        this.entityClass = entityClass;
        this.queryClass = queryClass;
    }

    public String getTable() {
        return If.isBlank(this.alias) ? this.table.get() : this.table.get() + " " + this.alias;
    }

    @Override
    public String getSqlSelect() {
        if (this.sqlSelect.isEmpty()) {
            return null;
        }
        String sql = String.join((CharSequence)", ", this.sqlSelect);
        return If.isBlank(sql) ? null : sql.trim();
    }

    public List<String> sqlSelect() {
        return this.sqlSelect;
    }

    public void customizedSql(String sql, Object parameter) {
        this.customizedSql = parameter == null ? sql : CustomizedSql.rewriteSql(sql, this.parameters, parameter);
    }

    @Override
    public String getQuerySql() {
        if (If.notBlank(this.customizedSql)) {
            return this.customizedSql;
        }
        String select = this.getSqlSelect();
        String where = this.getWhereSql();
        String sql = "SELECT " + (If.isBlank(select) ? "*" : select.trim()) + " " + "FROM" + " " + this.getTable() + " " + (If.isBlank(where) ? "" : "WHERE " + where.trim()) + " " + this.getGroupBy().trim() + " " + this.getOrderBy().trim() + " " + this.getLastSql().trim();
        return sql.trim();
    }

    @Override
    public String getUpdateStr() {
        String sql = this.updates.entrySet().stream().map(i -> (String)i.getKey() + " = " + (String)i.getValue()).collect(Collectors.joining(", "));
        return If.isBlank(sql) ? null : sql.trim();
    }

    @Override
    public String getMergeSql() {
        String sql = this.mergeSegments.sql();
        return If.isBlank(sql) ? null : sql.trim();
    }

    @Override
    public String getWhereSql() {
        return this.mergeSegments.whereSql();
    }

    @Override
    public String getGroupBy() {
        return this.mergeSegments.groupBy();
    }

    @Override
    public String getOrderBy() {
        return this.mergeSegments.orderBy();
    }

    @Override
    public String getLastSql() {
        return this.mergeSegments.last();
    }

    public void last(String lastSql) {
        this.mergeSegments.setLastSql(lastSql);
    }

    public void apply(KeyWordSegment keyWord, Column column, ISqlOp operator, Object ... paras) {
        this.apply(keyWord, column, operator, null, paras);
    }

    public void addSelectColumn(String column) {
        if (If.notBlank(column)) {
            this.sqlSelect.add(column);
            this.fieldAlias.addAll(WrapperData.parseAlias(column));
        }
    }

    static List<String> parseAlias(String column) {
        int pos = -1;
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buff = new StringBuilder();
        for (char c : (column + " ").toCharArray()) {
            if (pos <= 0 && MybatisUtil.isSpace(c)) {
                pos = 0;
                continue;
            }
            if (pos == 0 && (c == 'a' || c == 'A')) {
                pos = 1;
                continue;
            }
            if (pos == 1 && (c == 's' || c == 'S')) {
                pos = 2;
                continue;
            }
            if ((pos == 2 || pos == 3) && MybatisUtil.isSpace(c)) {
                pos = 3;
                continue;
            }
            if (pos >= 3 && (MybatisUtil.isLetter(c) || MybatisUtil.isDigit(c))) {
                pos = 4;
                buff.append(c);
                continue;
            }
            if (pos == 4 && (MybatisUtil.isSpace(c) || c == ',')) {
                list.add(buff.toString());
                buff = new StringBuilder();
                pos = -1;
                continue;
            }
            pos = -1;
        }
        return list;
    }

    public void apply(KeyWordSegment keyWord, Column column, ISqlOp operator, String format, Object ... args) {
        if (keyWord == null) {
            throw new FluentMybatisException("the first segment should be: 'AND', 'OR', 'GROUP BY', 'HAVING' or 'ORDER BY'");
        }
        String segment = operator.operator(column, this.getParameters(), format, args);
        this.getMergeSegments().add(keyWord, column.columnSegment(), () -> segment);
    }

    public void apply(KeyWordSegment keyWord, ISqlSegment ... segments) {
        if (keyWord == null) {
            throw new FluentMybatisException("the first segment should be: 'AND', 'OR', 'GROUP BY', 'HAVING' or 'ORDER BY'");
        }
        this.getMergeSegments().add(keyWord, segments);
    }

    public String paramSql(Column column, String functionSql, Object[] values) {
        return this.parameters.paramSql(column, functionSql, values);
    }

    public void updateSet(Column column, Object value) {
        this.updateSql(column, "?", value);
    }

    public void updateSql(Column column, String functionSql, Object ... values) {
        if (If.notBlank(functionSql)) {
            this.updates.put(column.wrapColumn(), this.paramSql(column, functionSql, values));
        }
    }

    public List<String> findWhereColumns() {
        WhereSegmentList list = this.getMergeSegments().getWhere();
        if (list == null || list.getSegments() == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> columns = new ArrayList<String>();
        for (ISqlSegment segment : list.getSegments()) {
            if (!(segment instanceof ColumnSegment)) continue;
            columns.add(segment.getSqlSegment());
        }
        return columns;
    }

    public void hint(HintType type, String hint) {
        if (If.notBlank(hint)) {
            this.hints.put(type, hint);
        }
    }

    public String hint(HintType type) {
        String hint = this.hints.get((Object)type);
        return If.isBlank(hint) ? " " : " " + hint + " ";
    }

    public void sharedParameter(WrapperData wrapperData) {
        this.getParameters().sharedParameter(wrapperData.getParameters());
    }

    public void sharedParameter(Parameters parameters) {
        this.getParameters().sharedParameter(parameters);
    }

    public ISqlSegment[] whereSegments() {
        return this.mergeSegments.getWhere().getSegments().toArray(new ISqlSegment[0]);
    }

    @Override
    public boolean isDistinct() {
        return this.isDistinct;
    }

    public String getAlias() {
        return this.alias;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public MergeSegments getMergeSegments() {
        return this.mergeSegments;
    }

    public PagedOffset getPaged() {
        return this.paged;
    }

    public Map<String, String> getUpdates() {
        return this.updates;
    }

    public Map<HintType, String> getHints() {
        return this.hints;
    }

    public Class getEntityClass() {
        return this.entityClass;
    }

    public Class getQueryClass() {
        return this.queryClass;
    }

    public Set<String> getFieldAlias() {
        return this.fieldAlias;
    }

    public boolean isIgnoreLockVersion() {
        return this.ignoreLockVersion;
    }

    public String getCustomizedSql() {
        return this.customizedSql;
    }

    public void setDistinct(boolean isDistinct) {
        this.isDistinct = isDistinct;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setPaged(PagedOffset paged) {
        this.paged = paged;
    }

    public void setIgnoreLockVersion(boolean ignoreLockVersion) {
        this.ignoreLockVersion = ignoreLockVersion;
    }
}

