/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.utility;

import cn.org.atool.fluent.mybatis.segment.model.Parameters;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.util.ArrayList;
import java.util.List;

public class CustomizedSql {
    static List<String> parse(String sql) {
        ArrayList<String> list = new ArrayList<String>();
        int index = 0;
        while (index < sql.length()) {
            int start = CustomizedSql.getStart(sql, index);
            if (start == -1) {
                list.add(sql.substring(index));
                break;
            }
            list.add(sql.substring(index, start));
            int end = sql.indexOf("}", start);
            if (end == -1) {
                throw new RuntimeException("illegal sql, starts '#{' or '${' in[" + start + "], but '}' not found. sql:" + sql);
            }
            String variable = sql.substring(start, end + 1);
            list.add(variable);
            index = end + 1;
        }
        return list;
    }

    private static int getStart(String sql, int index) {
        int start1 = sql.indexOf("#{", index);
        int start2 = sql.indexOf("${", index);
        if (start1 == -1) {
            return start2;
        }
        if (start2 == -1) {
            return start1;
        }
        return Math.min(start1, start2);
    }

    public static String rewriteSql(String sql, Parameters parameters, Object variable) {
        String prefix = CustomizedSql.getVarName(parameters.putParameter(null, variable));
        List<String> segments = CustomizedSql.parse(sql);
        StringBuilder buff = new StringBuilder();
        for (String segment : segments) {
            if (segment.startsWith("#{") && segment.endsWith("}")) {
                variable = CustomizedSql.renameVariable(prefix, CustomizedSql.getVarName(segment));
                buff.append("#{").append(variable).append("}");
                continue;
            }
            if (segment.startsWith("${") && segment.endsWith("}")) {
                variable = CustomizedSql.renameVariable(prefix, CustomizedSql.getVarName(segment));
                buff.append("${").append(variable).append("}");
                continue;
            }
            buff.append(segment);
        }
        return buff.toString();
    }

    private static String getVarName(String variable) {
        return variable.substring(2, variable.length() - 1).trim();
    }

    public static String renameVariable(String prefix, String variable) {
        char ch;
        if (variable.equals("value")) {
            return prefix;
        }
        if (variable.startsWith("value") && (MybatisUtil.isSpace(ch = variable.charAt(5)) || ch == '[' || ch == ',')) {
            return prefix + variable.substring(5);
        }
        return prefix + '.' + variable;
    }
}

