/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.utility;

import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.IRefs;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.functions.GetterFunc;
import cn.org.atool.fluent.mybatis.utility.LambdaUtil;
import java.util.ArrayList;
import java.util.stream.Stream;

public class MappingKits {
    public static <E extends IEntity> String[] toColumns(Class<E> klass, GetterFunc<E> getter, GetterFunc<E> ... getters) {
        ArrayList<String> list = new ArrayList<String>(getters.length + 1);
        list.add(MappingKits.toColumn(klass, getter));
        for (GetterFunc<E> func : getters) {
            list.add(MappingKits.toColumn(klass, func));
        }
        return list.toArray(new String[0]);
    }

    public static String[] toColumns(FieldMapping column, FieldMapping ... excludes) {
        ArrayList<String> list = new ArrayList<String>(excludes.length + 1);
        list.add(column.column);
        Stream.of(excludes).forEach(c -> list.add(c.column));
        return list.toArray(new String[0]);
    }

    public static <E extends IEntity> String toColumn(Class<E> klass, GetterFunc<E> func) {
        String field = LambdaUtil.resolve(func);
        return IRefs.instance().findColumnByField(klass, field);
    }
}

