/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.utility;

import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import cn.org.atool.fluent.mybatis.functions.MapFunction;
import cn.org.atool.fluent.mybatis.segment.model.PagedOffset;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.ObjectArray;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;

public class PoJoHelper {
    public static <POJO> List<POJO> toPoJoList(List<Map<String, Object>> list, MapFunction<POJO> converter) {
        return list == null ? null : list.stream().map(map -> PoJoHelper.toPoJo(map, converter)).collect(Collectors.toList());
    }

    public static <POJO> POJO toPoJo(Map<String, Object> map, @NonNull MapFunction<POJO> converter) {
        if (converter == null) {
            throw new NullPointerException("converter is marked non-null but is null");
        }
        return map == null ? null : (POJO)converter.apply(map);
    }

    public static <POJO> List<POJO> toPoJoList(Class<POJO> clazz, List<Map<String, Object>> list) {
        return list == null ? null : list.stream().map(map -> PoJoHelper.toPoJo(clazz, map)).collect(Collectors.toList());
    }

    public static <POJO> POJO toPoJo(@NonNull Class<POJO> clazz, @NonNull Map<String, Object> map) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        POJO target = PoJoHelper.newInstance(clazz);
        MetaObject metaObject = MetaObject.forObject(target, (ObjectFactory)new DefaultObjectFactory(), (ObjectWrapperFactory)new DefaultObjectWrapperFactory(), (ReflectorFactory)new DefaultReflectorFactory());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String name = MybatisUtil.underlineToCamel(entry.getKey(), false);
            Class type = metaObject.getSetterType(name);
            try {
                Object value = entry.getValue();
                if (value == null) {
                    metaObject.setValue(name, null);
                    continue;
                }
                if (type.isAssignableFrom(value.getClass())) {
                    metaObject.setValue(name, value);
                    continue;
                }
                PoJoHelper.setDefaultType(type, metaObject, name, value);
            }
            catch (Exception e) {
                throw new RuntimeException("convert map to object[type=" + clazz.getName() + ", property=" + entry.getKey() + ", type=" + type.getName() + "] error: " + e.getMessage(), e);
            }
        }
        return target;
    }

    private static <POJO> POJO newInstance(Class<POJO> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("convert map to object[type=" + clazz.getName() + "] error: " + e.getMessage(), e);
        }
    }

    public static Map toMap(Object object) {
        MybatisUtil.assertNotNull("object", object);
        Map<Object, Object> map = new HashMap();
        if (object instanceof IEntity) {
            map = ((IEntity)object).toEntityMap();
        } else if (object instanceof Map) {
            map.putAll((Map)object);
        } else {
            MetaObject metaObject = MetaObject.forObject((Object)object, (ObjectFactory)new DefaultObjectFactory(), (ObjectWrapperFactory)new DefaultObjectWrapperFactory(), (ReflectorFactory)new DefaultReflectorFactory());
            for (String field : metaObject.getGetterNames()) {
                map.put(field, metaObject.getValue(field));
            }
        }
        return map;
    }

    private static void setDefaultType(Class type, MetaObject metaObject, String name, Object value) {
        if (type == Long.class) {
            metaObject.setValue(name, (Object)Long.parseLong(value.toString()));
        } else if (type == Integer.class) {
            metaObject.setValue(name, (Object)Integer.parseInt(value.toString()));
        } else if (type == Boolean.class) {
            metaObject.setValue(name, (Object)ObjectArray.toBoolean(value));
        } else if (type == BigDecimal.class) {
            metaObject.setValue(name, (Object)new BigDecimal(value.toString()));
        } else if (type == BigInteger.class) {
            metaObject.setValue(name, (Object)new BigInteger(value.toString()));
        } else {
            metaObject.setValue(name, value);
        }
    }

    public static int validateTagPaged(IQuery query) {
        PagedOffset paged = query.getWrapperData().getPaged();
        if (paged == null) {
            throw new FluentMybatisException("Paged parameter not set");
        }
        if (paged.getOffset() != 0) {
            throw new FluentMybatisException("The offset of TagList should from zero, please use method: limit(size) or limit(0, size) .");
        }
        return paged.getLimit();
    }

    public static <T> Object[] getFields(List<T> list, Function<T, Object> getFunc) {
        return list.stream().map(getFunc).toArray(Object[]::new);
    }
}

