/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.processor;

import cn.org.atool.fluent.mybatis.annotation.FluentMybatis;
import cn.org.atool.fluent.mybatis.processor.base.IProcessor;
import cn.org.atool.fluent.mybatis.processor.entity.FluentList;
import cn.org.atool.fluent.mybatis.processor.scanner.FluentScanner;
import cn.org.atool.generator.util.GeneratorHelper;
import com.google.auto.service.AutoService;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"cn.org.atool.fluent.mybatis.annotation.FluentMybatis"})
@AutoService(value={Processor.class})
public class FluentMybatisProcessor
extends AbstractProcessor
implements IProcessor {
    protected Filer filer;
    private static Messager messager;
    private boolean generated = false;

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.filer = env.getFiler();
        messager = env.getMessager();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver() || this.generated) {
            return true;
        }
        messager.printMessage(Diagnostic.Kind.NOTE, "FluentMybatis process begin !!!");
        for (Element element : roundEnv.getRootElements()) {
            FluentMybatis fluent = element.getAnnotation(FluentMybatis.class);
            if (fluent == null) continue;
            messager.printMessage(Diagnostic.Kind.NOTE, "@FluentMybatis file analysis...");
            try {
                FluentScanner scanner = new FluentScanner(err -> messager.printMessage(Diagnostic.Kind.NOTE, (CharSequence)err));
                scanner.scan(element);
                FluentList.addFluent(scanner.getFluent());
            }
            catch (Exception e) {
                messager.printMessage(Diagnostic.Kind.ERROR, element.asType().toString() + ":\n" + GeneratorHelper.toString((Throwable)e));
                throw new RuntimeException(e);
            }
        }
        messager.printMessage(Diagnostic.Kind.NOTE, "@FluentMybatis file generating...");
        FluentList.generate(this.filer, err -> messager.printMessage(Diagnostic.Kind.NOTE, (CharSequence)err));
        messager.printMessage(Diagnostic.Kind.NOTE, "FluentMybatis process end !!!");
        this.generated = true;
        return true;
    }

    public static void error(String message) {
        messager.printMessage(Diagnostic.Kind.ERROR, message);
    }

    @Override
    public Messager getMessager() {
        return messager;
    }
}

