/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.processor.entity;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.annotation.FluentMybatis;
import cn.org.atool.fluent.mybatis.base.crud.IDefaultSetter;
import cn.org.atool.fluent.mybatis.base.mapper.IMapper;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.fluent.mybatis.processor.base.FluentClassName;
import cn.org.atool.fluent.mybatis.processor.entity.CommonField;
import cn.org.atool.fluent.mybatis.processor.entity.EntityRefMethod;
import cn.org.atool.fluent.mybatis.processor.entity.PrimaryField;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.util.ArrayList;
import java.util.List;

public class FluentEntity
extends FluentClassName
implements Comparable<FluentEntity> {
    private String basePack;
    private String entityPack;
    private String className;
    private String noSuffix;
    private String tableName;
    private String defaults;
    private String superMapper;
    private String prefix;
    private String suffix;
    private String mapperBeanPrefix;
    private PrimaryField primary;
    private final List<CommonField> fields = new ArrayList<CommonField>();
    private String logicDelete;
    private boolean longTypeOfLogicDelete = false;
    private String versionField;
    private final List<EntityRefMethod> refMethods = new ArrayList<EntityRefMethod>();
    private DbType dbType = DbType.MYSQL;

    public FluentEntity setClassName(String entityPack, String className) {
        this.className = className;
        this.entityPack = entityPack;
        this.basePack = this.getParentPackage(entityPack);
        return this;
    }

    private String getParentPackage(String entityPack) {
        int index = entityPack.lastIndexOf(46);
        return index > 0 ? entityPack.substring(0, index) : entityPack;
    }

    public FluentEntity setFluentMyBatis(FluentMybatis fluentMyBatis, String defaults, String superMapper) {
        this.prefix = fluentMyBatis.prefix();
        this.suffix = fluentMyBatis.suffix();
        this.noSuffix = this.className.replace(this.suffix, "");
        this.defaults = If.isBlank((CharSequence)defaults) ? IDefaultSetter.class.getName() : defaults;
        this.superMapper = If.isBlank((CharSequence)superMapper) ? IMapper.class.getName() : superMapper;
        this.tableName = fluentMyBatis.table();
        if (If.isBlank((CharSequence)this.tableName)) {
            this.tableName = MybatisUtil.tableName((String)this.className, (String)fluentMyBatis.prefix(), (String)fluentMyBatis.suffix());
        }
        this.mapperBeanPrefix = fluentMyBatis.mapperBeanPrefix();
        this.dbType = fluentMyBatis.dbType();
        return this;
    }

    public FluentEntity addMethod(EntityRefMethod method) {
        this.refMethods.add(method);
        return this;
    }

    public void addField(CommonField field) {
        if (this.fields.contains(field)) {
            return;
        }
        if (field.isPrimary() && this.primary == null) {
            this.primary = (PrimaryField)field;
        }
        this.fields.add(field);
    }

    @Override
    public int compareTo(FluentEntity fluentEntity) {
        return this.className.compareTo(fluentEntity.getClassName());
    }

    @Override
    public String getBasePack() {
        return this.basePack;
    }

    @Override
    public String getEntityPack() {
        return this.entityPack;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getNoSuffix() {
        return this.noSuffix;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDefaults() {
        return this.defaults;
    }

    public String getSuperMapper() {
        return this.superMapper;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getMapperBeanPrefix() {
        return this.mapperBeanPrefix;
    }

    public PrimaryField getPrimary() {
        return this.primary;
    }

    @Override
    public List<CommonField> getFields() {
        return this.fields;
    }

    public String getLogicDelete() {
        return this.logicDelete;
    }

    public boolean isLongTypeOfLogicDelete() {
        return this.longTypeOfLogicDelete;
    }

    public String getVersionField() {
        return this.versionField;
    }

    public List<EntityRefMethod> getRefMethods() {
        return this.refMethods;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public String toString() {
        return "FluentEntity(basePack=" + this.getBasePack() + ", entityPack=" + this.getEntityPack() + ", className=" + this.getClassName() + ", noSuffix=" + this.getNoSuffix() + ", tableName=" + this.getTableName() + ", defaults=" + this.getDefaults() + ", superMapper=" + this.getSuperMapper() + ", prefix=" + this.getPrefix() + ", suffix=" + this.getSuffix() + ", mapperBeanPrefix=" + this.getMapperBeanPrefix() + ", primary=" + this.getPrimary() + ", fields=" + this.getFields() + ", logicDelete=" + this.getLogicDelete() + ", longTypeOfLogicDelete=" + this.isLongTypeOfLogicDelete() + ", versionField=" + this.getVersionField() + ", refMethods=" + this.getRefMethods() + ", dbType=" + this.getDbType() + ")";
    }

    public void setLogicDelete(String logicDelete) {
        this.logicDelete = logicDelete;
    }

    public void setLongTypeOfLogicDelete(boolean longTypeOfLogicDelete) {
        this.longTypeOfLogicDelete = longTypeOfLogicDelete;
    }

    public void setVersionField(String versionField) {
        this.versionField = versionField;
    }
}

