/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.processor.entity;

import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.fluent.mybatis.processor.entity.FluentEntity;
import cn.org.atool.fluent.mybatis.processor.filer.AbstractFiler;
import cn.org.atool.fluent.mybatis.processor.filer.RefsFile;
import cn.org.atool.fluent.mybatis.processor.filer.refs.AllRefFiler;
import cn.org.atool.fluent.mybatis.processor.filer.refs.EntityRelationFiler;
import cn.org.atool.fluent.mybatis.processor.filer.refs.FieldRefFiler;
import cn.org.atool.fluent.mybatis.processor.filer.refs.FormRefFiler;
import cn.org.atool.fluent.mybatis.processor.filer.refs.MapperRefFiler;
import cn.org.atool.fluent.mybatis.processor.filer.refs.QueryRefFiler;
import cn.org.atool.fluent.mybatis.processor.filer.segment.BaseDaoFiler;
import cn.org.atool.fluent.mybatis.processor.filer.segment.DefaultsFiler;
import cn.org.atool.fluent.mybatis.processor.filer.segment.EntityHelperFiler;
import cn.org.atool.fluent.mybatis.processor.filer.segment.FormSetterFiler;
import cn.org.atool.fluent.mybatis.processor.filer.segment.MapperFiler;
import cn.org.atool.fluent.mybatis.processor.filer.segment.MappingFiler;
import cn.org.atool.fluent.mybatis.processor.filer.segment.QueryFiler;
import cn.org.atool.fluent.mybatis.processor.filer.segment.SqlProviderFiler;
import cn.org.atool.fluent.mybatis.processor.filer.segment.UpdaterFiler;
import cn.org.atool.fluent.mybatis.processor.filer.segment.WrapperHelperFiler;
import cn.org.atool.generator.javafile.AbstractFile;
import cn.org.atool.generator.util.GeneratorHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.processing.Filer;

public class FluentList {
    private static final List<FluentEntity> fluents = new ArrayList<FluentEntity>();
    private static final Map<String, FluentEntity> map = new HashMap<String, FluentEntity>();
    private static String samePackage = null;
    private static DbType dbType;

    public static void addFluent(FluentEntity fluent) {
        map.put(fluent.getClassName(), fluent);
        fluents.add(fluent);
        samePackage = GeneratorHelper.sameStartPackage((String)samePackage, (String)fluent.getBasePack());
    }

    public static String refsPackage() {
        return "cn.org.atool.fluent.mybatis.refs";
    }

    public static FluentEntity getFluentEntity(String entityName) {
        return map.get(entityName);
    }

    public static void generate(Filer filer, Consumer<String> logger) {
        fluents.sort(Comparator.comparing(FluentEntity::getNoSuffix));
        boolean first = true;
        for (FluentEntity fluent : FluentList.getFluents()) {
            try {
                List<AbstractFiler> javaFiles = FluentList.generateJavaFile(fluent);
                for (AbstractFiler javaFile : javaFiles) {
                    javaFile.javaFile().writeTo(filer);
                }
            }
            catch (Exception e) {
                logger.accept("FluentEntityInfo:" + fluent + "\n" + GeneratorHelper.toString((Throwable)e));
                throw new RuntimeException(e);
            }
            if (first) {
                dbType = fluent.getDbType();
            } else if (dbType != null && !Objects.equals(dbType, fluent.getDbType())) {
                dbType = null;
            }
            first = false;
        }
        if (fluents.isEmpty()) {
            return;
        }
        for (AbstractFile file : FluentList.refFiles()) {
            try {
                file.writeTo(filer);
            }
            catch (Exception e) {
                logger.accept("Generate Refs error:\n" + GeneratorHelper.toString((Throwable)e));
                throw new RuntimeException(e);
            }
        }
    }

    private static List<AbstractFile> refFiles() {
        return Arrays.asList(new AbstractFile[]{new AllRefFiler(), new FieldRefFiler(), new QueryRefFiler(), new FormRefFiler(), new RefsFile(), new EntityRelationFiler(), new MapperRefFiler()});
    }

    private static List<AbstractFiler> generateJavaFile(FluentEntity fluent) {
        return Arrays.asList(new MapperFiler(fluent), new MappingFiler(fluent), new EntityHelperFiler(fluent), new SqlProviderFiler(fluent), new WrapperHelperFiler(fluent), new QueryFiler(fluent), new UpdaterFiler(fluent), new BaseDaoFiler(fluent), new DefaultsFiler(fluent), new FormSetterFiler(fluent));
    }

    public static String getDbType() {
        return dbType == null ? null : dbType.name();
    }

    public static List<FluentEntity> getFluents() {
        return fluents;
    }

    public static String getSamePackage() {
        return samePackage;
    }
}

