/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.processor.filer.refs;

import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.processor.entity.FluentEntity;
import cn.org.atool.fluent.mybatis.processor.entity.FluentList;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.generator.javafile.AbstractFile;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;

public class FieldRefFiler
extends AbstractFile {
    private static final String FieldRef = "FieldRef";

    public static ClassName getClassName() {
        return ClassName.get((String)FluentList.refsPackage(), (String)FieldRef, (String[])new String[0]);
    }

    protected void staticImport(JavaFile.Builder builder) {
        builder.addStaticImport(MybatisUtil.class, new String[]{"notFluentMybatisException"});
        super.staticImport(builder);
    }

    public FieldRefFiler() {
        this.packageName = FluentList.refsPackage();
        this.klassName = FieldRef;
        this.comment = "Entity\u6240\u6709Mapping\u5f15\u7528";
    }

    protected void build(TypeSpec.Builder spec) {
        for (FluentEntity fluent : FluentList.getFluents()) {
            spec.addField(this.class_mapping(fluent));
        }
        spec.addField(this.f_allMappings()).addStaticBlock(this.m_initMapping()).addMethod(FieldRefFiler.m_findColumnByField(false)).addMethod(FieldRefFiler.m_findPrimaryColumn(false));
    }

    private FieldSpec f_allMappings() {
        return FieldSpec.builder((TypeName)this.parameterizedType(Map.class, new Class[]{Class.class, IMapping.class}), (String)"mappings", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("new $T<>()", new Object[]{HashMap.class}).build();
    }

    private FieldSpec class_mapping(FluentEntity fluent) {
        return FieldSpec.builder((TypeName)fluent.mapping(), (String)fluent.getNoSuffix(), (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PUBLIC, Modifier.STATIC}).initializer("$T.MAPPING", new Object[]{fluent.mapping()}).build();
    }

    private CodeBlock m_initMapping() {
        ArrayList<CodeBlock> list = new ArrayList<CodeBlock>();
        for (FluentEntity fluent : FluentList.getFluents()) {
            list.add(CodeBlock.of((String)"mappings.put($T.class, $T.MAPPING);\n", (Object[])new Object[]{fluent.entity(), fluent.mapping()}));
        }
        return CodeBlock.join(list, (String)"");
    }

    public static MethodSpec m_findPrimaryColumn(boolean isRef) {
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)"findPrimaryColumn").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(Class.class, "clazz", new Modifier[0]).returns(String.class);
        if (isRef) {
            spec.addAnnotation(Override.class).addStatement("return $T.findPrimaryColumn(clazz)", new Object[]{FieldRefFiler.getClassName()});
        } else {
            spec.addModifiers(new Modifier[]{Modifier.STATIC}).addJavadoc("\u8fd4\u56declazz\u5c5e\u6027\u5bf9\u5e94\u6570\u636e\u5e93\u4e3b\u952e\u5b57\u6bb5\u540d\u79f0", new Object[0]).addCode("if (mappings.containsKey(clazz)) {\n", new Object[0]).addStatement("\treturn mappings.get(clazz).findPrimaryColumn()", new Object[0]).addCode("}\n", new Object[0]).addStatement("throw $L(clazz)", new Object[]{"notFluentMybatisException"});
        }
        return spec.build();
    }

    public static MethodSpec m_findColumnByField(boolean isRef) {
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)"findColumnByField").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(Class.class, "clazz", new Modifier[0]).addParameter(String.class, "field", new Modifier[0]).returns(String.class);
        if (isRef) {
            spec.addAnnotation(Override.class).addStatement("return $T.findColumnByField(clazz, field)", new Object[]{FieldRefFiler.getClassName()});
        } else {
            spec.addModifiers(new Modifier[]{Modifier.STATIC}).addJavadoc("\u8fd4\u56declazz\u5c5e\u6027field\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u5b57\u6bb5\u540d\u79f0", new Object[0]).addCode("if (mappings.containsKey(clazz)) {\n", new Object[0]).addStatement("\treturn mappings.get(clazz).findColumnByField(field)", new Object[0]).addCode("}\n", new Object[0]).addStatement("throw $L(clazz)", new Object[]{"notFluentMybatisException"});
        }
        return spec.build();
    }

    protected boolean isInterface() {
        return false;
    }

    protected String generatorName() {
        return "FluentMybatis";
    }
}

