/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.processor.filer.refs;

import cn.org.atool.fluent.mybatis.base.crud.IDefaultGetter;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.crud.IUpdate;
import cn.org.atool.fluent.mybatis.processor.entity.FluentEntity;
import cn.org.atool.fluent.mybatis.processor.entity.FluentList;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.generator.javafile.AbstractFile;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;

public class QueryRefFiler
extends AbstractFile {
    private static final String QueryRef = "QueryRef";

    public static ClassName getClassName() {
        return ClassName.get((String)FluentList.refsPackage(), (String)QueryRef, (String[])new String[0]);
    }

    public QueryRefFiler() {
        this.packageName = FluentList.refsPackage();
        this.klassName = QueryRef;
        this.comment = "\u6784\u9020Entity\u5bf9\u5e94\u7684default query\n\u66f4\u65b0\u5668\u5de5\u5382\u7c7b\u5355\u4f8b\u5f15\u7528";
    }

    protected void staticImport(JavaFile.Builder builder) {
        builder.addStaticImport(MybatisUtil.class, new String[]{"notFluentMybatisException"});
        super.staticImport(builder);
    }

    protected void build(TypeSpec.Builder spec) {
        for (FluentEntity fluent : FluentList.getFluents()) {
            spec.addField(this.f_factory(fluent));
        }
        spec.addField(this.f_allQuerySupplier()).addStaticBlock(this.m_initSupplier()).addMethod(QueryRefFiler.m_defaultQuery(false)).addMethod(QueryRefFiler.m_emptyQuery(false)).addMethod(QueryRefFiler.m_defaultUpdater(false)).addMethod(QueryRefFiler.m_emptyUpdater(false)).addMethod(this.m_findDefaultGetter());
    }

    private FieldSpec f_factory(FluentEntity fluent) {
        return FieldSpec.builder((TypeName)fluent.defaults(), (String)fluent.lowerNoSuffix(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.INSTANCE", new Object[]{fluent.defaults()}).build();
    }

    public static MethodSpec m_defaultQuery(boolean isRef) {
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)"defaultQuery").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(Class.class, "clazz", new Modifier[0]).returns(IQuery.class);
        if (isRef) {
            spec.addAnnotation(Override.class).addStatement("Class entityClass = this.findFluentEntityClass(clazz)", new Object[0]).addStatement("return $T.defaultQuery(entityClass)", new Object[]{QueryRefFiler.getClassName()});
        } else {
            spec.addModifiers(new Modifier[]{Modifier.STATIC}).addJavadoc("\u8fd4\u56declazz\u5b9e\u4f53\u5bf9\u5e94\u7684\u9ed8\u8ba4Query\u5b9e\u4f8b", new Object[0]).addStatement("\treturn findDefault(clazz).defaultQuery()", new Object[0]);
        }
        return spec.build();
    }

    public static MethodSpec m_emptyQuery(boolean isRef) {
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)"emptyQuery").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(Class.class, "clazz", new Modifier[0]).returns(IQuery.class);
        if (isRef) {
            spec.addAnnotation(Override.class).addStatement("Class entityClass = this.findFluentEntityClass(clazz)", new Object[0]).addStatement("return $T.emptyQuery(entityClass)", new Object[]{QueryRefFiler.getClassName()});
        } else {
            spec.addModifiers(new Modifier[]{Modifier.STATIC}).addJavadoc("\u8fd4\u56declazz\u5b9e\u4f53\u5bf9\u5e94\u7684\u7a7aQuery\u5b9e\u4f8b", new Object[0]).addStatement("\treturn findDefault(clazz).query()", new Object[0]);
        }
        return spec.build();
    }

    public static MethodSpec m_defaultUpdater(boolean isRef) {
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)"defaultUpdater").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(Class.class, "clazz", new Modifier[0]).returns(IUpdate.class);
        if (isRef) {
            spec.addAnnotation(Override.class).addStatement("Class entityClass = this.findFluentEntityClass(clazz)", new Object[0]).addStatement("return $T.defaultUpdater(entityClass)", new Object[]{QueryRefFiler.getClassName()});
        } else {
            spec.addModifiers(new Modifier[]{Modifier.STATIC}).addJavadoc("\u8fd4\u56declazz\u5b9e\u4f53\u5bf9\u5e94\u7684\u9ed8\u8ba4Updater\u5b9e\u4f8b", new Object[0]).addStatement("\treturn findDefault(clazz).defaultUpdater()", new Object[0]);
        }
        return spec.build();
    }

    public static MethodSpec m_emptyUpdater(boolean isRef) {
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)"emptyUpdater").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(Class.class, "clazz", new Modifier[0]).returns(IUpdate.class);
        if (isRef) {
            spec.addAnnotation(Override.class).addStatement("Class entityClass = this.findFluentEntityClass(clazz)", new Object[0]).addStatement("return $T.emptyUpdater(entityClass)", new Object[]{QueryRefFiler.getClassName()});
        } else {
            spec.addModifiers(new Modifier[]{Modifier.STATIC}).addJavadoc("\u8fd4\u56declazz\u5b9e\u4f53\u5bf9\u5e94\u7684\u7a7aUpdater\u5b9e\u4f8b", new Object[0]).addStatement("\treturn findDefault(clazz).updater()", new Object[0]);
        }
        return spec.build();
    }

    private MethodSpec m_findDefaultGetter() {
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)"findDefault").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter(Class.class, "clazz", new Modifier[0]).returns(IDefaultGetter.class);
        spec.addModifiers(new Modifier[]{Modifier.STATIC}).addCode("if (Supplier.containsKey(clazz)) {\n", new Object[0]).addStatement("\treturn Supplier.get(clazz)", new Object[0]).addCode("}\n", new Object[0]).addStatement("throw $L(clazz)", new Object[]{"notFluentMybatisException"});
        return spec.build();
    }

    private CodeBlock m_initSupplier() {
        ArrayList<CodeBlock> list = new ArrayList<CodeBlock>();
        for (FluentEntity fluent : FluentList.getFluents()) {
            list.add(CodeBlock.of((String)"Supplier.put($T.class, $L);\n", (Object[])new Object[]{fluent.entity(), fluent.lowerNoSuffix()}));
        }
        return CodeBlock.join(list, (String)"");
    }

    private FieldSpec f_allQuerySupplier() {
        return FieldSpec.builder((TypeName)this.parameterizedType(Map.class, new Class[]{Class.class, IDefaultGetter.class}), (String)"Supplier", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("new $T<>()", new Object[]{HashMap.class}).build();
    }

    protected boolean isInterface() {
        return false;
    }

    protected String generatorName() {
        return "FluentMybatis";
    }
}

