/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.processor.filer.segment;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.BaseSqlProvider;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.crud.IUpdate;
import cn.org.atool.fluent.mybatis.base.mapper.IEntityMapper;
import cn.org.atool.fluent.mybatis.base.mapper.IRichMapper;
import cn.org.atool.fluent.mybatis.base.mapper.IWrapperMapper;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.mapper.FluentConst;
import cn.org.atool.fluent.mybatis.processor.base.FluentClassName;
import cn.org.atool.fluent.mybatis.processor.entity.CommonField;
import cn.org.atool.fluent.mybatis.processor.entity.FluentEntity;
import cn.org.atool.fluent.mybatis.processor.filer.AbstractFiler;
import cn.org.atool.fluent.mybatis.processor.filer.ClassNames2;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Options;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.ResultMap;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.type.JdbcType;

public class MapperFiler
extends AbstractFiler {
    private static final ClassName CN_Collection = ClassName.get(Collection.class);

    public MapperFiler(FluentEntity fluentEntity) {
        super(fluentEntity);
        this.packageName = MapperFiler.getPackageName(fluentEntity);
        this.klassName = MapperFiler.getClassName(fluentEntity);
        this.comment = "Mapper\u63a5\u53e3";
    }

    public static String getClassName(FluentClassName fluentEntity) {
        return fluentEntity.getNoSuffix() + "Mapper";
    }

    public static String getPackageName(FluentClassName fluentEntity) {
        return fluentEntity.getPackageName("mapper");
    }

    @Override
    protected void staticImport(JavaFile.Builder spec) {
        super.staticImport(spec);
        spec.addStaticImport(ClassName.get(FluentConst.class), new String[]{"*"});
    }

    @Override
    protected void build(TypeSpec.Builder spec) {
        spec.addSuperinterface(this.superMapperClass()).addSuperinterface(this.parameterizedType(ClassName.get(IRichMapper.class), new TypeName[]{this.fluent.entity()})).addSuperinterface(this.parameterizedType(ClassName.get(IWrapperMapper.class), new TypeName[]{this.fluent.entity()})).addSuperinterface(this.parameterizedType(ClassNames2.getClassName(this.fluent.getSuperMapper()), new TypeName[]{this.fluent.entity()})).addAnnotation(ClassNames2.Mybatis_Mapper).addAnnotation(AnnotationSpec.builder((ClassName)ClassNames2.Spring_Component).addMember("value", "$S", new Object[]{MapperFiler.getMapperName(this.fluent)}).build());
        spec.addField(FieldSpec.builder(String.class, (String)"ResultMap", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{this.fluent.getClassName() + "ResultMap"}).build());
        spec.addMethod(this.m_insert()).addMethod(this.m_insertWithPk()).addMethod(this.m_insertBatch()).addMethod(this.m_insertBatchWithPk()).addMethod(this.m_insertSelect()).addMethod(this.m_deleteById()).addMethod(this.m_logicDeleteById()).addMethod(this.m_deleteByIds()).addMethod(this.m_logicDeleteByIds()).addMethod(this.m_deleteByMap()).addMethod(this.m_logicDeleteByMap()).addMethod(this.m_delete()).addMethod(this.m_logicDelete()).addMethod(this.m_updateById()).addMethod(this.m_updateBy()).addMethod(this.m_findById()).addMethod(this.m_findOne()).addMethod(this.m_listByIds()).addMethod(this.m_listByMap()).addMethod(this.m_listEntity()).addMethod(this.m_listMaps()).addMethod(this.m_listObjs()).addMethod(this.m_count()).addMethod(this.m_countNoLimit());
        spec.addMethod(this.m_query()).addMethod(this.m_updater()).addMethod(this.m_defaultQuery()).addMethod(this.m_defaultUpdater()).addMethod(this.m_primaryField()).addMethod(this.m_entityClass());
    }

    private MethodSpec m_entityClass() {
        return super.publicMethod("entityClass", true, this.parameterizedType(ClassName.get(Class.class), new TypeName[]{this.fluent.entity()})).addModifiers(new Modifier[]{Modifier.DEFAULT}).addStatement("return $T.class", new Object[]{this.fluent.entity()}).build();
    }

    private MethodSpec m_primaryField() {
        MethodSpec.Builder builder = super.publicMethod("primaryField", true, FieldMapping.class).addModifiers(new Modifier[]{Modifier.DEFAULT});
        if (this.fluent.getPrimary() == null) {
            MapperFiler.throwPrimaryNoFound(builder);
        } else {
            builder.addStatement("return $T.$L", new Object[]{this.fluent.mapping(), this.fluent.getPrimary().getName()});
        }
        return builder.build();
    }

    private MethodSpec m_query() {
        return MethodSpec.methodBuilder((String)"query").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns((TypeName)this.fluent.query()).addStatement("return new $T()", new Object[]{this.fluent.query()}).build();
    }

    private MethodSpec m_defaultQuery() {
        return MethodSpec.methodBuilder((String)"defaultQuery").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns((TypeName)this.fluent.query()).addStatement("return $T.INSTANCE.$L()", new Object[]{this.fluent.defaults(), "defaultQuery"}).build();
    }

    private MethodSpec m_updater() {
        return MethodSpec.methodBuilder((String)"updater").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns((TypeName)this.fluent.updater()).addStatement("return new $T()", new Object[]{this.fluent.updater()}).build();
    }

    private MethodSpec m_defaultUpdater() {
        return MethodSpec.methodBuilder((String)"defaultUpdater").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns((TypeName)this.fluent.updater()).addStatement("return $T.INSTANCE.$L()", new Object[]{this.fluent.defaults(), "defaultUpdater"}).build();
    }

    public MethodSpec m_countNoLimit() {
        return this.mapperMethod(SelectProvider.class, "countNoLimit").addParameter(this.queryParam("query")).returns(Integer.class).build();
    }

    public MethodSpec m_count() {
        return this.mapperMethod(SelectProvider.class, "count").addParameter(this.queryParam("query")).returns(Integer.class).build();
    }

    public MethodSpec m_listObjs() {
        return this.mapperMethod(SelectProvider.class, "listObjs").addParameter(this.queryParam("query")).returns(this.parameterizedType(ClassName.get(List.class), new TypeName[]{TypeVariableName.get((String)"O")})).addTypeVariable(TypeVariableName.get((String)"O")).build();
    }

    public MethodSpec m_listMaps() {
        return this.mapperMethod(SelectProvider.class, "listMaps").addAnnotation(AnnotationSpec.builder(ResultType.class).addMember("value", "$T.class", new Object[]{Map.class}).build()).addParameter(this.queryParam("query")).returns(this.parameterizedType(ClassName.get(List.class), new TypeName[]{ClassNames2.CN_Map_StrObj})).build();
    }

    public MethodSpec m_listEntity() {
        return this.mapperMethod(SelectProvider.class, "listEntity").addAnnotation(this.annotation_ResultMap()).addParameter(this.queryParam("query")).returns(this.parameterizedType(ClassName.get(List.class), new TypeName[]{this.fluent.entity()})).build();
    }

    public MethodSpec m_listByMap() {
        return this.mapperMethod(SelectProvider.class, "listByMap").addAnnotation(this.annotation_ResultMap()).addParameter(this.param((TypeName)ClassNames2.CN_Map_StrObj, "columnMap", "Param_CM")).returns(this.parameterizedType(ClassName.get(List.class), new TypeName[]{this.fluent.entity()})).build();
    }

    public MethodSpec m_listByIds() {
        return this.mapperMethod(SelectProvider.class, "listByIds").addAnnotation(this.annotation_ResultMap()).addParameter(this.param(Collection.class, "ids", "Param_List")).returns(this.parameterizedType(ClassNames2.CN_List, new TypeName[]{this.fluent.entity()})).build();
    }

    public MethodSpec m_findOne() {
        return this.mapperMethod(SelectProvider.class, "findOne").addAnnotation(this.annotation_ResultMap()).addParameter(this.queryParam("query")).returns((TypeName)this.fluent.entity()).build();
    }

    public MethodSpec m_findById() {
        return this.mapperMethod(SelectProvider.class, "findById").addAnnotation(this.annotation_Results()).addParameter(Serializable.class, "id", new Modifier[0]).returns((TypeName)this.fluent.entity()).build();
    }

    public MethodSpec m_updateBy() {
        return this.mapperMethod(UpdateProvider.class, "updateBy").addParameter(this.param((TypeName)ArrayTypeName.of(IUpdate.class), "updates", "Param_EW")).addJavadoc(" {@link $T#updateBy($T)}", new Object[]{this.fluent.sqlProvider(), Map.class}).varargs(true).returns(TypeName.INT).build();
    }

    public MethodSpec m_updateById() {
        return this.mapperMethod(UpdateProvider.class, "updateById").addParameter(this.param((TypeName)this.fluent.entity(), "entity", "Param_ET")).returns(TypeName.INT).build();
    }

    public MethodSpec m_deleteByIds() {
        TypeName typeName = this.parameterizedType(ClassName.get(Collection.class), new TypeName[]{TypeVariableName.get((String)"? extends Serializable")});
        return this.mapperMethod(DeleteProvider.class, "deleteByIds").addJavadoc("@see $T#deleteByIds(Map)", new Object[]{this.fluent.sqlProvider()}).addParameter(this.param(typeName, "idList", "Param_List")).returns(TypeName.INT).build();
    }

    public MethodSpec m_logicDeleteByIds() {
        TypeName typeName = this.parameterizedType(ClassName.get(Collection.class), new TypeName[]{TypeVariableName.get((String)"? extends Serializable")});
        return this.mapperMethod(DeleteProvider.class, "logicDeleteByIds").addJavadoc("@see $T#logicDeleteByIds(Map)", new Object[]{this.fluent.sqlProvider()}).addParameter(this.param(typeName, "idList", "Param_List")).returns(TypeName.INT).build();
    }

    public MethodSpec m_delete() {
        return this.mapperMethod(DeleteProvider.class, "delete").addJavadoc("@see $T#delete(Map)", new Object[]{this.fluent.sqlProvider()}).addParameter(this.queryParam("wrapper")).returns(TypeName.INT).build();
    }

    public MethodSpec m_logicDelete() {
        return this.mapperMethod(DeleteProvider.class, "logicDelete").addJavadoc("@see $T#logicDelete(Map)", new Object[]{this.fluent.sqlProvider()}).addParameter(this.queryParam("wrapper")).returns(TypeName.INT).build();
    }

    public MethodSpec m_deleteByMap() {
        return this.mapperMethod(DeleteProvider.class, "deleteByMap").addJavadoc("@see $T#deleteByMap(Map)", new Object[]{this.fluent.sqlProvider()}).addParameter(ParameterSpec.builder((TypeName)ClassNames2.CN_Map_StrObj, (String)"cm", (Modifier[])new Modifier[0]).addAnnotation(this.annotation_Param("Param_CM")).build()).returns(TypeName.INT).build();
    }

    public MethodSpec m_logicDeleteByMap() {
        return this.mapperMethod(DeleteProvider.class, "logicDeleteByMap").addJavadoc("@see $T#logicDeleteByMap(Map)", new Object[]{this.fluent.sqlProvider()}).addParameter(ParameterSpec.builder((TypeName)ClassNames2.CN_Map_StrObj, (String)"cm", (Modifier[])new Modifier[0]).addAnnotation(this.annotation_Param("Param_CM")).build()).returns(TypeName.INT).build();
    }

    public MethodSpec m_deleteById() {
        return this.mapperMethod(DeleteProvider.class, "deleteById").addJavadoc("@see $T#deleteById(Serializable[])", new Object[]{this.fluent.sqlProvider()}).addParameter(this.param((TypeName)ClassNames2.CN_SerializableArray, "ids", "Param_List")).varargs(true).returns(TypeName.INT).build();
    }

    public MethodSpec m_logicDeleteById() {
        return this.mapperMethod(DeleteProvider.class, "logicDeleteById").addJavadoc("@see $T#logicDeleteById(Serializable[])", new Object[]{this.fluent.sqlProvider()}).addParameter(this.param((TypeName)ClassNames2.CN_SerializableArray, "ids", "Param_List")).varargs(true).returns(TypeName.INT).build();
    }

    public MethodSpec m_insertBatch() {
        MethodSpec.Builder builder = this.mapperMethod(InsertProvider.class, "insertBatch");
        if (this.fluent.getPrimary() != null) {
            if (this.fluent.getPrimary().isAutoIncrease() && If.isBlank((CharSequence)this.fluent.getPrimary().getSeqName())) {
                this.addOptions(builder);
            } else {
                this.addSelectKey(builder);
            }
        }
        TypeName listType = this.parameterizedType(CN_Collection, new TypeName[]{this.fluent.entity()});
        return builder.addParameter(this.param(listType, "entities", "Param_List")).returns(TypeName.INT).build();
    }

    public MethodSpec m_insertBatchWithPk() {
        MethodSpec.Builder builder = this.mapperMethod(InsertProvider.class, "insertBatchWithPk");
        TypeName listType = this.parameterizedType(CN_Collection, new TypeName[]{this.fluent.entity()});
        return builder.addParameter(this.param(listType, "entities", "Param_List")).returns(TypeName.INT).build();
    }

    public MethodSpec m_insertSelect() {
        MethodSpec.Builder builder = this.mapperMethod(InsertProvider.class, "insertSelect");
        return builder.addJavadoc("@see $T#insertSelect(Map)", new Object[]{this.fluent.sqlProvider()}).addParameter(this.param(String[].class, "fields", "Param_Fields")).addParameter(this.queryParam("ew")).returns(TypeName.INT).build();
    }

    public MethodSpec m_insert() {
        MethodSpec.Builder builder = this.mapperMethod(InsertProvider.class, "insert");
        if (this.fluent.getPrimary() != null) {
            if (this.fluent.getPrimary().isAutoIncrease() && If.isBlank((CharSequence)this.fluent.getPrimary().getSeqName())) {
                this.addOptions(builder);
            } else {
                this.addSelectKey(builder);
            }
        }
        return builder.addParameter((TypeName)this.fluent.entity(), "entity", new Modifier[0]).returns(TypeName.INT).addJavadoc("{@link $T#insert($T)}", new Object[]{BaseSqlProvider.class, IEntity.class}).build();
    }

    public MethodSpec m_insertWithPk() {
        MethodSpec.Builder builder = this.mapperMethod(InsertProvider.class, "insertWithPk");
        return builder.addParameter((TypeName)this.fluent.entity(), "entity", new Modifier[0]).returns(TypeName.INT).build();
    }

    private void addSelectKey(MethodSpec.Builder builder) {
        String seqName = this.fluent.getDbType().feature.getSeq();
        boolean before = this.fluent.getDbType().feature.isBefore();
        if (If.notBlank((CharSequence)this.fluent.getPrimary().getSeqName())) {
            seqName = this.fluent.getPrimary().getSeqName();
            before = this.fluent.getPrimary().isSeqIsBeforeOrder();
        }
        if (If.isBlank((CharSequence)seqName)) {
            return;
        }
        builder.addAnnotation(AnnotationSpec.builder(SelectKey.class).addMember("resultType", "$T.class", new Object[]{this.fluent.getPrimary().getJavaType()}).addMember("keyProperty", "$S", new Object[]{this.fluent.getPrimary().getName()}).addMember("keyColumn", "$S", new Object[]{this.fluent.getPrimary().getColumn()}).addMember("before", "$L", new Object[]{before}).addMember("statement", "$S", new Object[]{seqName}).build());
    }

    private void addOptions(MethodSpec.Builder builder) {
        builder.addAnnotation(AnnotationSpec.builder(Options.class).addMember("useGeneratedKeys", "true", new Object[0]).addMember("keyProperty", "$S", new Object[]{this.fluent.getPrimary().getName()}).addMember("keyColumn", "$S", new Object[]{this.fluent.getPrimary().getColumn()}).build());
    }

    @Override
    protected boolean isInterface() {
        return true;
    }

    private MethodSpec.Builder mapperMethod(Class provider, String methodName) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName);
        builder.addAnnotation(Override.class);
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
        builder.addAnnotation(AnnotationSpec.builder((Class)provider).addMember("type", "$T.class", new Object[]{this.fluent.sqlProvider()}).addMember("method", "$S", new Object[]{methodName}).build());
        return builder;
    }

    private TypeName superMapperClass() {
        return super.parameterizedType(ClassName.get(IEntityMapper.class), new TypeName[]{this.fluent.entity()});
    }

    public static String getMapperName(FluentEntity fluentEntity) {
        String className = fluentEntity.getNoSuffix() + "Mapper";
        if (If.isBlank((CharSequence)fluentEntity.getMapperBeanPrefix())) {
            return MybatisUtil.lowerFirst((String)className, (String)"");
        }
        return fluentEntity.getMapperBeanPrefix() + className;
    }

    private AnnotationSpec annotation_ResultMap() {
        return AnnotationSpec.builder(ResultMap.class).addMember("value", "ResultMap", new Object[0]).build();
    }

    private AnnotationSpec annotation_Results() {
        ArrayList<CodeBlock> results = new ArrayList<CodeBlock>();
        for (CommonField field : this.fluent.getFields()) {
            ArrayList<CodeBlock> blocks = new ArrayList<CodeBlock>();
            blocks.add(CodeBlock.of((String)"@$T(", (Object[])new Object[]{Result.class}));
            blocks.add(CodeBlock.of((String)"column = $S", (Object[])new Object[]{field.getColumn()}));
            blocks.add(CodeBlock.of((String)", property = $S", (Object[])new Object[]{field.getName()}));
            blocks.add(CodeBlock.of((String)", javaType = $T.class", (Object[])new Object[]{field.getJavaType()}));
            if (field.isPrimary()) {
                blocks.add(CodeBlock.of((String)", id = true", (Object[])new Object[0]));
            }
            if (field.getJdbcType() != null) {
                blocks.add(CodeBlock.of((String)", jdbcType = $T.$L", (Object[])new Object[]{JdbcType.class, field.getJdbcType()}));
            }
            if (field.getTypeHandler() != null) {
                blocks.add(CodeBlock.of((String)", typeHandler = $T.class", (Object[])new Object[]{field.getTypeHandler()}));
            }
            blocks.add(CodeBlock.of((String)")", (Object[])new Object[0]));
            results.add(CodeBlock.join(blocks, (String)""));
        }
        return AnnotationSpec.builder(Results.class).addMember("id", "ResultMap", new Object[0]).addMember("value", "{\n$L\n}", new Object[]{CodeBlock.join(results, (String)",\n")}).build();
    }

    private AnnotationSpec annotation_Param(String value) {
        return AnnotationSpec.builder(Param.class).addMember("value", "$L", new Object[]{value}).build();
    }

    private ParameterSpec queryParam(String param_ew) {
        return this.param(IQuery.class, param_ew, "Param_EW");
    }

    private ParameterSpec param(Class type, String varName, String paraName) {
        return ParameterSpec.builder((Type)type, (String)varName, (Modifier[])new Modifier[0]).addAnnotation(this.annotation_Param(paraName)).build();
    }

    private ParameterSpec param(TypeName type, String varName, String paraName) {
        return ParameterSpec.builder((TypeName)type, (String)varName, (Modifier[])new Modifier[0]).addAnnotation(this.annotation_Param(paraName)).build();
    }
}

