/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.processor.filer.segment;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.BaseSqlProvider;
import cn.org.atool.fluent.mybatis.base.model.InsertList;
import cn.org.atool.fluent.mybatis.base.model.UpdateDefault;
import cn.org.atool.fluent.mybatis.base.model.UpdateSet;
import cn.org.atool.fluent.mybatis.mapper.FluentConst;
import cn.org.atool.fluent.mybatis.mapper.MapperSql;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.fluent.mybatis.processor.base.FluentClassName;
import cn.org.atool.fluent.mybatis.processor.entity.CommonField;
import cn.org.atool.fluent.mybatis.processor.entity.FieldOrMethod;
import cn.org.atool.fluent.mybatis.processor.entity.FluentEntity;
import cn.org.atool.fluent.mybatis.processor.filer.AbstractFiler;
import cn.org.atool.fluent.mybatis.processor.filer.ClassNames2;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.SqlProviderUtils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.Modifier;

public class SqlProviderFiler
extends AbstractFiler {
    public static String getClassName(FluentClassName fluentEntity) {
        return fluentEntity.getNoSuffix() + "SqlProvider";
    }

    public static String getPackageName(FluentClassName fluentEntity) {
        return fluentEntity.getPackageName("helper");
    }

    public SqlProviderFiler(FluentEntity fluentEntity) {
        super(fluentEntity);
        this.packageName = SqlProviderFiler.getPackageName(fluentEntity);
        this.klassName = SqlProviderFiler.getClassName(fluentEntity);
        this.comment = "\u52a8\u6001\u8bed\u53e5\u5c01\u88c5";
    }

    @Override
    protected void staticImport(JavaFile.Builder spec) {
        super.staticImport(spec);
        spec.addStaticImport(MybatisUtil.class, new String[]{"*"});
        spec.addStaticImport(SqlProviderUtils.class, new String[]{"*"});
        spec.addStaticImport(FluentConst.class, new String[]{"*"});
        spec.addStaticImport(this.fluent.mapping(), new String[]{"*"});
        spec.addStaticImport(InsertList.class, new String[]{"el"});
    }

    @Override
    protected void build(TypeSpec.Builder spec) {
        spec.superclass(this.parameterizedType(ClassName.get(BaseSqlProvider.class), new TypeName[]{this.fluent.entity()}));
        spec.addField(this.f_defaults());
        spec.addMethod(this.m_primaryIsNull());
        spec.addMethod(this.m_primaryNotNull());
        spec.addMethod(this.m_insertEntity());
        spec.addMethod(this.m_insertBatchEntity());
        spec.addMethod(this.m_updateById());
        spec.addMethod(this.m_updateDefaults());
        spec.addMethod(this.m_tableName());
        spec.addMethod(this.m_mapping());
        spec.addMethod(this.m_allFields());
        spec.addMethod(this.m_setEntityByDefault());
        spec.addMethod(this.m_dbType());
        spec.addMethod(this.m_longTypeOfLogicDelete());
    }

    private MethodSpec m_longTypeOfLogicDelete() {
        return super.protectedMethod("longTypeOfLogicDelete", true, ClassName.BOOLEAN).addStatement("return $L", new Object[]{this.fluent.isLongTypeOfLogicDelete()}).build();
    }

    private MethodSpec m_setEntityByDefault() {
        return super.protectedMethod("setEntityByDefault", true, null).addParameter(IEntity.class, "entity", new Modifier[0]).addStatement("defaults.setEntityByDefault(entity)", new Object[0]).build();
    }

    private MethodSpec m_updateDefaults() {
        MethodSpec.Builder builder = super.publicMethod("updateDefaults", true, (TypeName)ClassNames2.CN_List_Str).addParameter((TypeName)ClassNames2.CN_Map_StrStr, "updates", new Modifier[0]).addParameter(ClassName.BOOLEAN, "ignoreLockVersion", new Modifier[0]);
        builder.addStatement("UpdateDefault defaults = new $T(updates)", new Object[]{UpdateDefault.class});
        for (CommonField field : this.fluent.getFields()) {
            if (If.isBlank((CharSequence)field.getUpdate())) continue;
            if (Objects.equals(field.getName(), this.fluent.getVersionField())) {
                builder.addCode("if (!ignoreLockVersion) {\n", new Object[0]);
                builder.addStatement("\tdefaults.add(dbType(), $L, $S)", new Object[]{field.getName(), field.getUpdate()});
                builder.addCode("}\n", new Object[0]);
                continue;
            }
            builder.addStatement("defaults.add(dbType(), $L, $S)", new Object[]{field.getName(), field.getUpdate()});
        }
        return builder.addStatement("return defaults.getUpdateDefaults()", new Object[0]).build();
    }

    private MethodSpec m_updateById() {
        MethodSpec.Builder spec = super.publicMethod("updateById", false, String.class).addParameter((TypeName)ClassNames2.CN_Map_StrObj, "map", new Modifier[0]);
        if (this.ifNotPrimary(spec)) {
            return spec.build();
        }
        spec.addStatement("$T entity = getParas(map, Param_ET)", new Object[]{this.fluent.entity()});
        spec.addStatement("assertNotNull(Param_Entity, entity)", new Object[0]);
        spec.addStatement("$T sql = new MapperSql()", new Object[]{MapperSql.class});
        spec.addStatement("sql.UPDATE(this.tableName())", new Object[0]);
        spec.addCode("$T updates = new UpdateSet()", new Object[]{UpdateSet.class});
        FieldOrMethod versionField = null;
        for (CommonField field : this.fluent.getFields()) {
            if (Objects.equals(field.getName(), this.fluent.getVersionField())) {
                spec.addCode("\n\t.add(this.dbType(), $L, null, $S)", new Object[]{field.getName(), field.getUpdate()});
                versionField = field;
                continue;
            }
            if (field.isPrimary()) continue;
            spec.addCode("\n\t.add(this.dbType(), $L, entity.$L(), $S)", new Object[]{field.getName(), field.getMethodName(), field.getUpdate()});
        }
        spec.addCode(";\n", new Object[0]);
        if (versionField != null) {
            spec.addStatement("assertNotNull($S, entity.$L())", new Object[]{String.format("lock version field(%s)", versionField.getName()), ((CommonField)versionField).getMethodName()});
        }
        spec.addStatement("sql.SET(updates.getUpdates())", new Object[0]);
        spec.addStatement("sql.WHERE($L.el(this.dbType(), Param_ET))", new Object[]{this.fluent.getPrimary().getName()});
        if (versionField != null) {
            spec.addStatement("sql.APPEND($S)", new Object[]{" AND "});
            spec.addStatement("sql.APPEND($L.el(this.dbType(), Param_ET))", new Object[]{versionField.getName()});
        }
        return spec.addStatement("return sql.toString()", new Object[0]).build();
    }

    private MethodSpec m_primaryIsNull() {
        MethodSpec.Builder spec = super.publicMethod("primaryIsNull", true, ClassName.BOOLEAN).addParameter((TypeName)this.fluent.entity(), "entity", new Modifier[0]);
        if (this.fluent.getPrimary() == null) {
            spec.addStatement("return true", new Object[0]);
        } else {
            spec.addStatement("return entity.$L() == null", new Object[]{this.fluent.getPrimary().getMethodName()});
        }
        return spec.build();
    }

    private MethodSpec m_primaryNotNull() {
        MethodSpec.Builder spec = super.publicMethod("primaryNotNull", true, ClassName.BOOLEAN).addParameter((TypeName)this.fluent.entity(), "entity", new Modifier[0]);
        if (this.fluent.getPrimary() == null) {
            spec.addStatement("return true", new Object[0]);
        } else {
            spec.addStatement("return entity.$L() != null", new Object[]{this.fluent.getPrimary().getMethodName()});
        }
        return spec.build();
    }

    private MethodSpec m_insertEntity() {
        MethodSpec.Builder spec = super.protectedMethod("insertEntity", true, null).addParameter(InsertList.class, "inserts", new Modifier[0]).addParameter(String.class, "prefix", new Modifier[0]).addParameter((TypeName)this.fluent.entity(), "entity", new Modifier[0]).addParameter(ClassName.BOOLEAN, "withPk", new Modifier[0]);
        for (CommonField field : this.fluent.getFields()) {
            if (field.isPrimary()) {
                spec.addCode("if (withPk) {\n", new Object[0]).addStatement("\tinserts.add(prefix, $L, entity.$L(), $S)", new Object[]{field.getName(), field.getMethodName(), field.getInsert()}).addCode("}\n", new Object[0]);
                continue;
            }
            spec.addStatement("inserts.add(prefix, $L, entity.$L(), $S)", new Object[]{field.getName(), field.getMethodName(), field.getInsert()});
        }
        return spec.build();
    }

    private MethodSpec m_insertBatchEntity() {
        MethodSpec.Builder spec = super.protectedMethod("insertBatchEntity", true, (TypeName)ClassNames2.CN_List_Str).addParameter(ClassName.INT, "index", new Modifier[0]).addParameter((TypeName)this.fluent.entity(), "entity", new Modifier[0]).addParameter(ClassName.BOOLEAN, "withPk", new Modifier[0]).addStatement("$T<String> values = new $T<>()", new Object[]{List.class, ArrayList.class});
        for (CommonField field : this.fluent.getFields()) {
            if (field.isPrimary()) {
                spec.addCode("if (withPk) {\n", new Object[0]).addStatement("\tvalues.add(el($S + index + $S, $L, entity.$L(), $S))", new Object[]{"list[", "].", field.getName(), field.getMethodName(), field.getInsert()}).addCode("}\n", new Object[0]);
                continue;
            }
            spec.addStatement("values.add(el($S + index + $S, $L, entity.$L(), $S))", new Object[]{"list[", "].", field.getName(), field.getMethodName(), field.getInsert()});
        }
        spec.addStatement("return values", new Object[0]);
        return spec.build();
    }

    private MethodSpec m_tableName() {
        return super.publicMethod("tableName", true, String.class).addStatement("return defaults.table().get()", new Object[0]).build();
    }

    private MethodSpec m_allFields() {
        MethodSpec.Builder spec = super.publicMethod("allFields", true, (TypeName)ClassNames2.CN_List_Str).addParameter(ClassName.BOOLEAN, "withPk", new Modifier[0]);
        spec.addCode("if (withPk) {\n", new Object[0]).addStatement("\treturn $T.asList($L)", new Object[]{Arrays.class, this.getFields(true)}).addCode("} else {\n", new Object[0]).addStatement("\treturn $T.asList($L)", new Object[]{Arrays.class, this.getFields(false)}).addCode("}", new Object[0]);
        return spec.build();
    }

    private String getFields(boolean withPk) {
        StringBuilder fields = new StringBuilder();
        boolean first = true;
        for (CommonField field : this.fluent.getFields()) {
            if (field.isPrimary() && !withPk) continue;
            if (!first) {
                fields.append(", ");
            }
            first = false;
            fields.append('\"').append(field.getColumn()).append('\"');
        }
        return fields.toString();
    }

    private MethodSpec m_dbType() {
        return super.publicMethod("dbType", true, DbType.class).addStatement("return $T.$L", new Object[]{DbType.class, this.fluent.getDbType().name()}).build();
    }

    private boolean ifNotPrimary(MethodSpec.Builder builder) {
        if (this.fluent.getPrimary() == null) {
            SqlProviderFiler.throwPrimaryNoFound(builder);
            return true;
        }
        return false;
    }

    @Override
    protected boolean isInterface() {
        return false;
    }
}

