/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.processor.scanner;

import cn.org.atool.fluent.mybatis.annotation.FluentMybatis;
import cn.org.atool.fluent.mybatis.annotation.LogicDelete;
import cn.org.atool.fluent.mybatis.annotation.NotField;
import cn.org.atool.fluent.mybatis.annotation.RefMethod;
import cn.org.atool.fluent.mybatis.annotation.TableField;
import cn.org.atool.fluent.mybatis.annotation.TableId;
import cn.org.atool.fluent.mybatis.annotation.Version;
import cn.org.atool.fluent.mybatis.base.crud.IDefaultSetter;
import cn.org.atool.fluent.mybatis.base.mapper.IMapper;
import cn.org.atool.fluent.mybatis.processor.FluentMybatisProcessor;
import cn.org.atool.fluent.mybatis.processor.entity.CommonField;
import cn.org.atool.fluent.mybatis.processor.entity.EntityRefMethod;
import cn.org.atool.fluent.mybatis.processor.entity.FluentEntity;
import cn.org.atool.fluent.mybatis.processor.entity.PrimaryField;
import cn.org.atool.fluent.mybatis.processor.filer.ClassNames2;
import cn.org.atool.fluent.mybatis.processor.scanner.ClassAttrParser;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner8;

public class FluentScanner
extends ElementScanner8<Void, Void> {
    final Consumer<String> logger;
    private final FluentEntity fluent;

    public FluentScanner(Consumer<String> logger) {
        this.logger = logger;
        this.fluent = new FluentEntity();
    }

    @Override
    public Void visitType(TypeElement entity, Void aVoid) {
        FluentMybatis fluentMybatis = entity.getAnnotation(FluentMybatis.class);
        if (fluentMybatis == null) {
            FluentMybatisProcessor.error("Error in: " + entity.getQualifiedName().toString());
        } else {
            ClassName className = ClassNames2.getClassName(entity.getQualifiedName().toString());
            this.fluent.setClassName(className.packageName(), className.simpleName());
            String defaults = ClassAttrParser.getClassAttr(entity, "defaults()", IDefaultSetter.class);
            String superMapper = ClassAttrParser.getClassAttr(entity, "superMapper()", IMapper.class);
            this.fluent.setFluentMyBatis(fluentMybatis, defaults, superMapper);
        }
        return (Void)super.visitType(entity, aVoid);
    }

    @Override
    public Void visitExecutable(ExecutableElement element, Void aVoid) {
        if (element.getModifiers().contains((Object)Modifier.STATIC) || element.getModifiers().contains((Object)Modifier.ABSTRACT) || !element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return (Void)super.visitExecutable(element, aVoid);
        }
        RefMethod ref = element.getAnnotation(RefMethod.class);
        if (ref == null) {
            return (Void)super.visitExecutable(element, aVoid);
        }
        String methodName = element.getSimpleName().toString();
        EntityRefMethod method = new EntityRefMethod(methodName, ClassName.get((TypeMirror)element.getReturnType()));
        method.setValue(ref.value());
        this.fluent.addMethod(method);
        return (Void)super.visitExecutable(element, aVoid);
    }

    @Override
    public Void visitVariable(VariableElement element, Void aVoid) {
        if (element.getKind() != ElementKind.FIELD || element.getModifiers().contains((Object)Modifier.STATIC) || element.getModifiers().contains((Object)Modifier.TRANSIENT) || element.getAnnotation(NotField.class) != null) {
            return (Void)super.visitVariable(element, aVoid);
        }
        TableId tableId = element.getAnnotation(TableId.class);
        String fieldName = element.getSimpleName().toString();
        if (tableId == null) {
            CommonField field = this.parseCommonField(fieldName, element);
            this.fluent.addField(field);
            if (element.getAnnotation(LogicDelete.class) != null) {
                this.fluent.setLogicDelete(field.getName());
                this.fluent.setLongTypeOfLogicDelete(Objects.equals(field.getJavaType(), ClassNames2.CN_Long));
            }
            if (element.getAnnotation(Version.class) != null) {
                this.fluent.setVersionField(field.getName());
            }
        } else {
            PrimaryField field = this.parsePrimaryField(fieldName, element, tableId);
            this.fluent.addField(field);
        }
        return (Void)super.visitVariable(element, aVoid);
    }

    private CommonField parseCommonField(String fieldName, VariableElement var) {
        CommonField field = new CommonField(fieldName, ClassName.get((TypeMirror)var.asType()));
        TableField tableField = var.getAnnotation(TableField.class);
        if (tableField == null) {
            return field;
        }
        field.setColumn(tableField.value());
        field.setInsert(tableField.insert());
        field.setUpdate(tableField.update());
        field.setNotLarge(tableField.notLarge());
        field.setNumericScale(tableField.numericScale());
        field.setJdbcType(tableField.jdbcType().name());
        for (AnnotationMirror annotationMirror : var.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().contains(TableField.class.getSimpleName())) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : values.entrySet()) {
                String method = entry.getKey().getSimpleName().toString();
                AnnotationValue value = entry.getValue();
                if (!"typeHandler".equals(method)) continue;
                field.setTypeHandler((TypeName)ClassNames2.getClassName(value.getValue().toString()));
            }
        }
        return field;
    }

    private PrimaryField parsePrimaryField(String fieldName, VariableElement var, TableId tableId) {
        PrimaryField field = new PrimaryField(fieldName, ClassName.get((TypeMirror)var.asType()));
        field.setColumn(tableId.value());
        field.setAutoIncrease(tableId.auto());
        field.setSeqIsBeforeOrder(tableId.before());
        field.setJdbcType(tableId.jdbcType().name());
        field.setSeqName(tableId.seqName());
        return field;
    }

    public FluentEntity getFluent() {
        return this.fluent;
    }
}

