/*
 * Decompiled with CFR 0.152.
 */
package com.github.avarabyeu.jashing.core;

import com.github.avarabyeu.jashing.core.Configuration;
import com.github.avarabyeu.jashing.core.EventSource;
import com.github.avarabyeu.jashing.core.eventsource.SimpleEventSource;
import com.github.avarabyeu.jashing.core.eventsource.annotation.EventId;
import com.github.avarabyeu.jashing.core.eventsource.annotation.Frequency;
import com.github.avarabyeu.jashing.utils.InstanceOfMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ServiceManager;
import com.google.inject.Binder;
import com.google.inject.Exposed;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.name.Names;
import com.google.inject.spi.Message;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.ClassLoaderRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventsModule
extends PrivateModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventsModule.class);
    private final List<Configuration.EventConfig> eventConfigs;
    private final InstanceOfMap<Module> extensionsMap;

    public EventsModule(@Nonnull List<Configuration.EventConfig> eventConfigs) {
        this(eventConfigs, null);
    }

    public EventsModule(@Nonnull List<Configuration.EventConfig> eventConfigs, @Nullable List<Module> extensions) {
        this.eventConfigs = (List)Preconditions.checkNotNull(eventConfigs, (Object)"Event configs shouldn't be null");
        this.extensionsMap = null == extensions ? InstanceOfMap.empty() : InstanceOfMap.builder().fromList(extensions);
    }

    protected void configure() {
        try {
            this.extensionsMap.values().forEach(arg_0 -> ((EventsModule)this).install(arg_0));
            Map<String, Class<? extends Service>> eventSources = this.mapEventSources();
            Multibinder eventSourceMultibinder = Multibinder.newSetBinder((Binder)this.binder(), Service.class);
            for (Configuration.EventConfig event : this.eventConfigs) {
                if (Strings.isNullOrEmpty((String)event.getSource())) {
                    this.binder().addError("Event source is not specified for event with id '%s'", new Object[]{event.getId()});
                    continue;
                }
                if (!eventSources.containsKey(event.getSource())) {
                    this.binder().addError("Unable to find event source with name '%s'. Available sources: \n%s", new Object[]{event.getSource(), Joiner.on((char)'\n').join(eventSources.keySet())});
                    continue;
                }
                this.install((Module)new EventSourcePrivateModule(event, (Multibinder<Service>)eventSourceMultibinder, eventSources.get(event.getSource())));
            }
        }
        catch (IOException e) {
            this.addError(new Message("Unable to load event handlers...", (Throwable)e));
        }
    }

    @Provides
    @Singleton
    @Exposed
    public ServiceManager serviceManager(Set<Service> eventSources) {
        ServiceManager serviceManager = new ServiceManager(eventSources);
        serviceManager.addListener(new ServiceManager.Listener(){

            public void healthy() {
                LOGGER.info("Event sources have bootstrapped!");
            }

            public void stopped() {
                LOGGER.info("Event sources have stopped");
            }
        });
        return serviceManager;
    }

    @VisibleForTesting
    Map<String, Class<? extends Service>> mapEventSources() throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ImmutableSet classes = ClassPath.from((ClassLoader)classLoader).getAllClasses();
        ClassLoaderRepository repository = new ClassLoaderRepository(classLoader);
        LOGGER.info("Scanning classpath for EventHandlers....");
        Map<String, Class<? extends Service>> collected = classes.parallelStream().map(classInfo -> {
            try {
                return Optional.of(repository.loadClass(classInfo.getName()));
            }
            catch (ClassNotFoundException e) {
                LOGGER.trace("Class cannot be loaded: {}", (Object)classInfo.getName(), (Object)e);
                return Optional.empty();
            }
        }).filter(((Predicate<Optional>)Optional::isPresent).and(javaClassOptional -> Arrays.stream(((JavaClass)javaClassOptional.get()).getAnnotationEntries()).anyMatch(annotationEntry -> Type.getType((String)annotationEntry.getAnnotationType()).toString().equals(EventSource.class.getCanonicalName()))).and(javaClassOptional -> {
            try {
                return Arrays.stream(((JavaClass)javaClassOptional.get()).getAllInterfaces()).anyMatch(iface -> iface.getClassName().equals(Service.class.getCanonicalName()));
            }
            catch (ClassNotFoundException e) {
                LOGGER.trace("Class annotations cannot be loaded: {}", (Object)((JavaClass)javaClassOptional.get()).getClassName(), (Object)e);
                return false;
            }
        })).map(javaClassOptional -> {
            try {
                return classLoader.loadClass(((JavaClass)javaClassOptional.get()).getClassName());
            }
            catch (ClassNotFoundException e) {
                LOGGER.trace("Class cannot be loaded: {}", (Object)((JavaClass)javaClassOptional.get()).getClassName(), (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toMap(clazz -> clazz.getAnnotation(EventSource.class).value(), clazz -> clazz));
        LOGGER.info("Found {} event handlers", (Object)collected.size());
        return collected;
    }

    private class EventSourcePrivateModule
    extends PrivateModule {
        private Configuration.EventConfig event;
        private Multibinder<Service> multibinder;
        private Class<? extends Service> eventSourceClass;

        public EventSourcePrivateModule(Configuration.EventConfig event, Multibinder<Service> multibinder, Class<? extends Service> eventSourceClass) {
            this.event = event;
            this.multibinder = multibinder;
            this.eventSourceClass = eventSourceClass;
        }

        protected void configure() {
            LOGGER.info("Registering event source [{}] for event [{}]", (Object)this.eventSourceClass.getSimpleName(), (Object)this.event.getId());
            this.validateEvent();
            if (!Objects.isNull(this.event.getFrequency())) {
                this.binder().bind(Duration.class).annotatedWith(Frequency.class).toInstance((Object)Duration.ofSeconds(this.event.getFrequency()));
            }
            this.binder().bind(String.class).annotatedWith(EventId.class).toInstance((Object)this.event.getId());
            Key eventSourceKey = Key.get(Service.class, (Annotation)Names.named((String)this.event.getId()));
            this.binder().bind(eventSourceKey).to(this.eventSourceClass);
            this.expose(eventSourceKey);
            this.multibinder.addBinding().to(eventSourceKey);
            if (null != this.event.getProperties()) {
                this.event.getProperties().entrySet().forEach(entry -> this.bindProperty((String)entry.getKey(), entry.getValue()));
            }
            if (!EventSource.NOP.class.equals(this.eventSourceClass.getAnnotation(EventSource.class).explicitConfiguration())) {
                LOGGER.info("       Registering extension module for event source [{}]", (Object)this.eventSourceClass.getSimpleName());
                Class<? extends Module> extensionModuleClass = this.eventSourceClass.getAnnotation(EventSource.class).explicitConfiguration();
                Module extensionModule = EventsModule.this.extensionsMap.getInstanceOf(extensionModuleClass);
                if (null == extensionModule) {
                    try {
                        this.install(extensionModuleClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (InstantiationException | InvocationTargetException e) {
                        LOGGER.error("Unable to initialize extension", (Throwable)e);
                        this.addError("Unable to create instance of extension module '%s' for event with ID '%s'. Exception '%s'", new Object[]{extensionModuleClass, this.event.getId(), e.getMessage()});
                    }
                    catch (IllegalAccessException | NoSuchMethodException e) {
                        LOGGER.error("Unable to initialize extension", (Throwable)e);
                        this.addError("Unable to create instance of extension module '%s' for event with ID '%s'. Look like it doesn't have default constructor. Please, register it explicitly", new Object[]{extensionModuleClass, this.event.getId()});
                    }
                }
            }
        }

        private <T> void bindProperty(String key, T value) {
            TypeLiteral type = TypeLiteral.get(value.getClass());
            OptionalBinder.newOptionalBinder((Binder)this.binder(), (Key)Key.get((TypeLiteral)type, (Annotation)Names.named((String)key))).setBinding().toInstance(value);
        }

        private void validateEvent() {
            if (!(SimpleEventSource.class.isAssignableFrom(this.eventSourceClass) || this.event.getFrequency() != null && this.event.getFrequency() > 0L)) {
                this.binder().addError("Frequency of event with ID '%s' is not specified", new Object[]{this.event.getId()});
            }
            if (null == this.event.getId()) {
                this.binder().addError("ID of event with ID '%s' is not specified", new Object[]{this.event.getId()});
            }
        }
    }
}

