/*
 * Decompiled with CFR 0.152.
 */
package com.github.avarabyeu.jashing.core;

import com.github.avarabyeu.jashing.core.JashingModule;
import com.github.avarabyeu.jashing.core.JashingServer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ServiceManager;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Jashing {
    private static final Logger LOGGER = LoggerFactory.getLogger(Jashing.class);
    private AtomicBoolean bootstrapped;
    private Injector injector;
    private Thread shutdownHook;

    private Jashing(Injector injector) {
        this.injector = injector;
        this.bootstrapped = new AtomicBoolean(false);
        this.shutdownHook = new Thread(this::shutdown);
    }

    public Jashing bootstrap() {
        if (!this.bootstrapped.compareAndSet(false, true)) {
            throw new IllegalStateException("Jashing already bootstrapped");
        }
        ServiceManager eventSources = (ServiceManager)this.injector.getInstance(ServiceManager.class);
        eventSources.startAsync();
        Service application = (Service)this.injector.getInstance(JashingServer.class);
        application.startAsync();
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        LOGGER.info("Jashing has started!");
        return this;
    }

    public void shutdown() {
        if (this.bootstrapped.compareAndSet(true, false)) {
            LOGGER.info("Shutting down Jashing...");
            ((ServiceManager)this.injector.getInstance(ServiceManager.class)).stopAsync().awaitStopped();
            ((JashingServer)((Object)this.injector.getInstance(JashingServer.class))).stopAsync().awaitTerminated();
            if (!this.shutdownHook.isAlive()) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
        } else {
            throw new IllegalStateException("Jashing is not bootstrapped");
        }
        LOGGER.info("Jashing has stopped.");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void main(String ... args) throws InterruptedException, IOException {
        try {
            Jashing.builder().build().bootstrap();
        }
        catch (Exception e) {
            LOGGER.error("Jashing cannot start", (Throwable)e);
        }
    }

    public static class Builder {
        private List<Module> modules = new LinkedList<Module>();
        private Integer port;

        public Builder withPort(int port) {
            Preconditions.checkArgument((0 < port ? 1 : 0) != 0, (String)"Port incorrect port number %s", (Object[])new Object[]{port});
            this.port = port;
            return this;
        }

        public Builder registerModule(Module ... modules) {
            if (null != modules) {
                Collections.addAll(this.modules, modules);
            }
            return this;
        }

        public Jashing build() {
            Injector createdInjector = Guice.createInjector((Module[])new Module[]{new JashingModule(this.port, (List<Module>)ImmutableList.builder().addAll(this.modules).build())});
            return new Jashing(createdInjector);
        }
    }
}

