/*
 * Decompiled with CFR 0.152.
 */
package com.github.avarabyeu.jashing.core;

import com.github.avarabyeu.jashing.core.Configuration;
import com.github.avarabyeu.jashing.core.EventsModule;
import com.github.avarabyeu.jashing.core.JashingServer;
import com.github.avarabyeu.jashing.utils.ResourceUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.EventBus;
import com.google.common.io.Resources;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import com.google.gson.Gson;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JashingModule
extends AbstractModule {
    private static final Integer DEFAULT_PORT = 8181;
    private static final Logger LOGGER = LoggerFactory.getLogger(JashingModule.class);
    private static final String APPLICATION_CONFIG = "config.json";
    private static final String TIMEOUT_PROPERTY = "timeout";
    private final Integer port;
    private final List<Module> extensions;

    public JashingModule(List<Module> extensions) {
        this(null, extensions);
    }

    public JashingModule(@Nullable Integer port, List<Module> extensions) {
        this.port = port;
        this.extensions = extensions;
    }

    protected void configure() {
        this.binder().requireExplicitBindings();
        EventBus eventBus = new EventBus((exception, context) -> LOGGER.error("Could not dispatch event: {} to {}", new Object[]{context.getSubscriber(), context.getSubscriberMethod(), exception.getCause()}));
        this.binder().bind(EventBus.class).toInstance((Object)eventBus);
        Gson gson = new Gson();
        this.binder().bind(Gson.class).toInstance((Object)gson);
        Configuration configuration = this.provideConfiguration(gson);
        Map<String, String> properties = configuration.getProperties();
        Map<String, String> envVars = System.getenv();
        Map<String, String> globalProperties = properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)envVars.getOrDefault(e.getKey(), (String)e.getValue())));
        globalProperties.entrySet().forEach(entry -> this.binder().bindConstant().annotatedWith((Annotation)Names.named((String)((String)entry.getKey()))).to((String)entry.getValue()));
        this.binder().install((Module)new EventsModule(configuration.getEvents(), this.extensions));
        this.binder().bind(JashingServer.class).toProvider(() -> {
            Optional<Long> timeout = globalProperties.containsKey(TIMEOUT_PROPERTY) ? Optional.of(Long.valueOf((String)globalProperties.get(TIMEOUT_PROPERTY))) : Optional.empty();
            final Integer port = this.port == null ? DEFAULT_PORT : this.port;
            JashingServer jashing = new JashingServer(port, eventBus, gson, timeout);
            jashing.addListener(new Service.Listener(){

                public void running() {
                    LOGGER.info("Embedded Jashing server has started on port [{}]", (Object)port);
                }

                public void stopping(Service.State from) {
                    LOGGER.info("Stopping embedded Jashing server");
                }
            }, MoreExecutors.directExecutor());
            return jashing;
        }).in(Scopes.SINGLETON);
    }

    private Configuration provideConfiguration(Gson gson) {
        try {
            URL config = ResourceUtils.getResourceAsURL(APPLICATION_CONFIG);
            Preconditions.checkState((config != null ? 1 : 0) != 0, (String)"Main application config [%s] not found", (Object[])new Object[]{APPLICATION_CONFIG});
            return (Configuration)gson.fromJson((Reader)Resources.asCharSource((URL)config, (Charset)Charsets.UTF_8).openBufferedStream(), Configuration.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read configuration", e);
        }
    }
}

