/*
 * Decompiled with CFR 0.152.
 */
package com.github.avarabyeu.jashing.core;

import com.github.avarabyeu.jashing.core.Jashing;
import com.github.avarabyeu.jashing.core.JashingEvent;
import com.github.avarabyeu.jashing.core.WroManagerFactory;
import com.github.avarabyeu.jashing.core.eventsource.annotation.NoCache;
import com.github.avarabyeu.jashing.utils.StringUtils;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.RateLimiter;
import com.google.gson.Gson;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.sse.ServerSentEventConnection;
import io.undertow.server.handlers.sse.ServerSentEventHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Deque;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import ro.isdc.wro.http.ConfigurableWroFilter;

class JashingServer
extends AbstractIdleService {
    public static final AttachmentKey<RateLimiter> RATE_LIMITER_KEY = AttachmentKey.create(RateLimiter.class);
    private final Integer port;
    private final EventBus eventBus;
    private final Gson gson;
    private final Optional<Long> timeout;
    private ServerSentEventHandler sseHandler;
    private Undertow server;

    public JashingServer(Integer port, EventBus eventBus, Gson gson, Optional<Long> timeout) {
        this.port = port;
        this.eventBus = eventBus;
        this.gson = gson;
        this.timeout = timeout;
    }

    protected void startUp() throws Exception {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_23);
        configuration.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(Jashing.class, "/"));
        final ConcurrentMap eventCache = Maps.newConcurrentMap();
        this.sseHandler = Handlers.serverSentEvents((connection, lastEventId) -> this.timeout.ifPresent(timeout -> {
            connection.putAttachment(RATE_LIMITER_KEY, (Object)RateLimiter.create((double)timeout.longValue()));
            eventCache.values().forEach(serverSentEvent -> this.sendEvent(connection, (JashingEvent)serverSentEvent));
        }));
        this.eventBus.register((Object)new Consumer<JashingEvent>(){

            @Override
            @Subscribe
            public void accept(JashingEvent serverSentEvent) {
                if (!serverSentEvent.getClass().isAnnotationPresent(NoCache.class)) {
                    eventCache.put(serverSentEvent.getId(), serverSentEvent);
                }
                JashingServer.this.sseHandler.getConnections().parallelStream().forEach(c -> JashingServer.this.sendEvent(c, serverSentEvent));
            }
        });
        ResourceHandler widgetsHandler = Handlers.resource((ResourceManager)new ClassPathResourceManager(Thread.currentThread().getContextClassLoader(), "statics"));
        RoutingHandler routingHandler = Handlers.routing().get("/views/{widget}", exchange -> {
            exchange.setStatusCode(302);
            String widgetName = (String)((Deque)exchange.getQueryParameters().get("widget")).getFirst();
            exchange.getResponseHeaders().put(Headers.LOCATION, "/assets/widgets/" + StringUtils.substringBefore(widgetName, ".html") + "/" + widgetName);
            exchange.endExchange();
        }).get("/{dashboard}", exchange -> {
            StringWriter out = new StringWriter();
            configuration.getTemplate("/views/dashboards/" + (String)((Deque)exchange.getQueryParameters().get("dashboard")).poll() + ".ftl.html").process((Object)Collections.EMPTY_MAP, (Writer)out);
            exchange.getResponseSender().send(out.toString());
        }).get("/events", (HttpHandler)this.sseHandler).get("/", (HttpHandler)Handlers.redirect((String)"/sample"));
        PathHandler rootHandler = Handlers.path((HttpHandler)routingHandler).addPrefixPath("/assets", (HttpHandler)widgetsHandler).addPrefixPath("/compiled", this.getAggregationHandler());
        this.server = Undertow.builder().addHttpListener(this.port.intValue(), "0.0.0.0").setHandler((HttpHandler)rootHandler).build();
        this.server.start();
    }

    private void sendEvent(ServerSentEventConnection c, JashingEvent serverSentEvent) {
        Optional.ofNullable(c.getAttachment(RATE_LIMITER_KEY)).ifPresent(RateLimiter::acquire);
        c.send(this.gson.toJson((Object)serverSentEvent));
    }

    private HttpHandler getAggregationHandler() throws ServletException {
        DeploymentInfo deploymentInfo = Servlets.deployment().setClassLoader(JashingServer.class.getClassLoader()).setContextPath("/").setDeploymentName("jashing").addFilterUrlMapping("wro4j", "/*", DispatcherType.REQUEST).addFilter(Servlets.filter((String)"wro4j", ConfigurableWroFilter.class, (InstanceFactory)new InstanceFactory<ConfigurableWroFilter>(){

            public InstanceHandle<ConfigurableWroFilter> createInstance() throws InstantiationException {
                ConfigurableWroFilter filter = new ConfigurableWroFilter();
                filter.setWroManagerFactory((ro.isdc.wro.manager.factory.WroManagerFactory)new WroManagerFactory());
                return new ImmediateInstanceHandle((Object)filter);
            }
        }));
        DeploymentManager deployment = Servlets.defaultContainer().addDeployment(deploymentInfo);
        deployment.deploy();
        return deployment.start();
    }

    protected void shutDown() throws Exception {
        this.sseHandler.getConnections().forEach(ServerSentEventConnection::shutdown);
        this.server.stop();
    }
}

