/*
 * Decompiled with CFR 0.152.
 */
package com.github.avarabyeu.jashing.core;

import com.github.avarabyeu.jashing.core.IncorrectConfigurationException;
import com.google.common.io.CharStreams;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import ro.isdc.wro.extensions.processor.css.RubySassCssProcessor;
import ro.isdc.wro.extensions.processor.js.CoffeeScriptProcessor;
import ro.isdc.wro.manager.factory.ConfigurableWroManagerFactory;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.factory.XmlModelFactory;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.decorator.ProcessorDecorator;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.processor.factory.SimpleProcessorsFactory;
import ro.isdc.wro.model.resource.processor.impl.css.CssUrlRewritingProcessor;

class WroManagerFactory
extends ConfigurableWroManagerFactory {
    private static final String COFFEE_FILENAME = ".coffee";

    WroManagerFactory() {
    }

    protected ProcessorsFactory newProcessorsFactory() {
        SimpleProcessorsFactory factory = new SimpleProcessorsFactory();
        factory.addPreProcessor((ResourcePreProcessor)new ProcessorDecorator(new CoffeeScriptProcessor()){

            public void process(Resource resource, Reader reader, Writer writer) throws IOException {
                if (resource.getUri().endsWith(WroManagerFactory.COFFEE_FILENAME)) {
                    super.process(resource, reader, writer);
                } else {
                    CharStreams.copy((Readable)reader, (Appendable)writer);
                }
            }
        });
        factory.addPreProcessor((ResourcePreProcessor)new CssUrlRewritingProcessor());
        factory.addPostProcessor((ResourcePostProcessor)new RubySassCssProcessor());
        return factory;
    }

    protected WroModelFactory newModelFactory() {
        return new XmlModelFactory(){

            protected InputStream getModelResourceAsStream() throws IOException {
                return Resources.asByteSource((URL)Resources.getResource((String)"wro.xml")).openStream();
            }
        };
    }

    protected Properties newConfigProperties() {
        Properties properties = new Properties();
        try (InputStream is = Resources.asByteSource((URL)Resources.getResource((String)"wro.properties")).openStream();){
            properties.load(is);
        }
        catch (IOException e) {
            throw new IncorrectConfigurationException("Unable to load wro configuration");
        }
        return properties;
    }
}

