/*
 * Decompiled with CFR 0.152.
 */
package com.github.avarabyeu.jashing.core.eventsource;

import com.github.avarabyeu.jashing.core.JashingEvent;
import com.github.avarabyeu.jashing.core.eventsource.annotation.EventId;
import com.github.avarabyeu.jashing.core.eventsource.annotation.Frequency;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.inject.Inject;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public abstract class ScheduledEventSource<T extends JashingEvent>
extends AbstractScheduledService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduledEventSource.class);
    @Frequency
    @Inject
    private Duration period;
    @EventId
    @Inject
    private String eventId;
    @Inject
    private EventBus eventBus;

    protected final void runOneIteration() throws Exception {
        try {
            this.sendEvent((JashingEvent)this.produceEvent());
        }
        catch (Exception e) {
            LOGGER.error(MessageFormatter.format((String)"Cannot produce event with id {}", (Object)this.eventId).getMessage(), (Throwable)e);
        }
    }

    protected final void sendEvent(JashingEvent t) {
        if (null != t) {
            if (Objects.isNull(t.getId())) {
                t.setId(this.eventId);
            }
            this.eventBus.post((Object)t);
        }
    }

    protected final AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)3L, (long)this.period.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    protected final String serviceName() {
        return "ScheduledEventSource[eventID=" + this.eventId + "]";
    }

    protected abstract T produceEvent();
}

