/*
 * Decompiled with CFR 0.152.
 */
package com.github.avarabyeu.jashing.utils;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.inject.Provider;

public final class GuiceUtils {
    private GuiceUtils() {
    }

    public static Key<String> getPropertyKey(String propertyName) {
        return Key.get(String.class, (Annotation)Names.named((String)propertyName));
    }

    public static Provider<String> getPropertyProvider(Binder binder, String propertyName) {
        return binder.getProvider(GuiceUtils.getPropertyKey(propertyName));
    }

    public static Provider<String> bindDefault(Binder binder, String propertyName, String defaultValue) {
        Key<String> propertyKey = GuiceUtils.getPropertyKey(propertyName);
        OptionalBinder optionalBinder = OptionalBinder.newOptionalBinder((Binder)binder, propertyKey);
        optionalBinder.setDefault().toInstance((Object)defaultValue);
        return binder.getProvider(propertyKey);
    }
}

