/*
 * Decompiled with CFR 0.152.
 */
package com.github.avarabyeu.jashing.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class InstanceOfMap<T>
extends ForwardingMap<Class<? extends T>, T> {
    private Map<Class<? extends T>, T> delegate;

    private InstanceOfMap(Map<Class<? extends T>, T> delegate) {
        this.delegate = delegate;
    }

    protected Map<Class<? extends T>, T> delegate() {
        return this.delegate;
    }

    public T put(@Nullable Class<? extends T> clazz, @Nullable T value) {
        return this.delegate.put(clazz, value);
    }

    public T getInstanceOf(Class<? extends T> clazz) {
        if (this.delegate.containsKey(clazz)) {
            return this.delegate.get(clazz);
        }
        return this.delegate.entrySet().stream().filter(entry -> clazz.isAssignableFrom((Class)entry.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InstanceOfMap that = (InstanceOfMap)((Object)o);
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delegate);
    }

    public Collection<T> values() {
        return this.delegate.values();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> InstanceOfMap<T> empty() {
        return new InstanceOfMap(Collections.emptyMap());
    }

    public static class Builder<T> {
        public InstanceOfMap<T> fromList(List<? extends T> list) {
            Preconditions.checkNotNull(list, (Object)"Provided list is null!");
            HashMap map = new HashMap(list.size());
            for (T item : list) {
                map.put(item.getClass(), item);
            }
            return new InstanceOfMap(map);
        }

        public InstanceOfMap<T> fromArray(T ... array) {
            Preconditions.checkNotNull(array, (Object)"Provided array is null!");
            return this.fromList(Arrays.asList(array));
        }

        public InstanceOfMap<T> fromMap(Map<Class<? extends T>, T> map) {
            return new InstanceOfMap(map);
        }
    }
}

