/*
 * Decompiled with CFR 0.152.
 */
package com.github.avarabyeu.jashing.utils;

import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public final class ResourceUtils {
    private ResourceUtils() {
    }

    public static Properties getResourceAsProperties(String resource) {
        return ResourceUtils.getResourceAs(resource, source -> {
            try (InputStream is = source.openStream();){
                Properties properties = new Properties();
                properties.load(is);
                Properties properties2 = properties;
                return properties2;
            }
        });
    }

    public static File getResourceAsTempFile(String resource) {
        return ResourceUtils.getResourceAs(resource, source -> {
            String fileName = Files.getNameWithoutExtension((String)resource);
            String extension = Files.getFileExtension((String)resource);
            File tempFile = File.createTempFile(fileName, "." + extension);
            source.copyTo(Files.asByteSink((File)tempFile, (FileWriteMode[])new FileWriteMode[0]));
            return tempFile;
        });
    }

    public static Source getResourceAsSource(String resource) {
        return ResourceUtils.getResourceAs(resource, source -> new StreamSource(source.openBufferedStream()));
    }

    public static String getResourceAsString(String resource) {
        return ResourceUtils.getResourceAs(resource, source -> source.asCharSource(Charset.defaultCharset()).read());
    }

    public static byte[] getResourceAsByteArray(String resource) {
        return ResourceUtils.getResourceAs(resource, ByteSource::read);
    }

    public static URL getResourceAsURL(String resource) {
        return Resources.getResource((String)resource);
    }

    public static ByteSource getResourceAsByteSource(String resource) {
        return Resources.asByteSource((URL)ResourceUtils.getResourceAsURL(resource));
    }

    public static <T> T getResourceAs(String resource, IOConverter<T> converter) {
        try {
            ByteSource source = ResourceUtils.getResourceAsByteSource(resource);
            return converter.convert(source);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to convert resource with name '" + resource + "' using converter " + converter.getClass(), e);
        }
    }

    private static interface IOConverter<T> {
        public T convert(ByteSource var1) throws IOException;
    }
}

