/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.jodd;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.HttpResponseProxy;
import me.chanjar.weixin.common.util.http.MediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class JoddHttpMediaDownloadRequestExecutor
extends MediaDownloadRequestExecutor<HttpConnectionProvider, ProxyInfo> {
    public JoddHttpMediaDownloadRequestExecutor(RequestHttp requestHttp, File tmpDirFile) {
        super(requestHttp, tmpDirFile);
    }

    @Override
    public File execute(String uri, String queryParam) throws WxErrorException, IOException {
        if (queryParam != null) {
            if (uri.indexOf(63) == -1) {
                uri = uri + '?';
            }
            uri = uri + (uri.endsWith("?") ? queryParam : '&' + queryParam);
        }
        HttpRequest request = HttpRequest.get((String)uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            ((HttpConnectionProvider)this.requestHttp.getRequestHttpClient()).useProxy((ProxyInfo)this.requestHttp.getRequestHttpProxy());
        }
        request.withConnectionProvider((HttpConnectionProvider)this.requestHttp.getRequestHttpClient());
        HttpResponse response = request.send();
        response.charset("UTF-8");
        String contentType = response.header("Content-Type");
        if (contentType != null && contentType.startsWith("application/json")) {
            throw new WxErrorException(WxError.fromJson(response.bodyText()));
        }
        String fileName = new HttpResponseProxy(response).getFileName();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(response.bodyBytes());
        return FileUtils.createTmpFile(inputStream, FilenameUtils.getBaseName((String)fileName), FilenameUtils.getExtension((String)fileName), this.tmpDirFile);
    }
}

