/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jodd.http.HttpResponse;
import me.chanjar.weixin.common.error.WxErrorException;
import okhttp3.Response;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;

public class HttpResponseProxy {
    private static final Pattern PATTERN = Pattern.compile(".*filename=\"(.*)\"");
    private CloseableHttpResponse apacheHttpResponse;
    private HttpResponse joddHttpResponse;
    private Response okHttpResponse;

    public HttpResponseProxy(CloseableHttpResponse apacheHttpResponse) {
        this.apacheHttpResponse = apacheHttpResponse;
    }

    public HttpResponseProxy(HttpResponse joddHttpResponse) {
        this.joddHttpResponse = joddHttpResponse;
    }

    public HttpResponseProxy(Response okHttpResponse) {
        this.okHttpResponse = okHttpResponse;
    }

    public String getFileName() throws WxErrorException {
        if (this.apacheHttpResponse != null) {
            return this.getFileName(this.apacheHttpResponse);
        }
        if (this.joddHttpResponse != null) {
            return this.getFileName(this.joddHttpResponse);
        }
        if (this.okHttpResponse != null) {
            return this.getFileName(this.okHttpResponse);
        }
        return null;
    }

    private String getFileName(CloseableHttpResponse response) throws WxErrorException {
        Header[] contentDispositionHeader = response.getHeaders("Content-disposition");
        if (contentDispositionHeader == null || contentDispositionHeader.length == 0) {
            throw new WxErrorException("\u65e0\u6cd5\u83b7\u53d6\u5230\u6587\u4ef6\u540d");
        }
        return this.extractFileNameFromContentString(contentDispositionHeader[0].getValue());
    }

    private String getFileName(HttpResponse response) throws WxErrorException {
        String content = response.header("Content-disposition");
        return this.extractFileNameFromContentString(content);
    }

    private String getFileName(Response response) throws WxErrorException {
        String content = response.header("Content-disposition");
        return this.extractFileNameFromContentString(content);
    }

    private String extractFileNameFromContentString(String content) throws WxErrorException {
        if (content == null || content.length() == 0) {
            throw new WxErrorException("\u65e0\u6cd5\u83b7\u53d6\u5230\u6587\u4ef6\u540d");
        }
        Matcher m = PATTERN.matcher(content);
        if (m.matches()) {
            return m.group(1);
        }
        throw new WxErrorException("\u65e0\u6cd5\u83b7\u53d6\u5230\u6587\u4ef6\u540d");
    }
}

