/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.fs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import org.apache.commons.io.IOUtils;

public class FileUtils {
    public static File createTmpFile(InputStream inputStream, String name, String ext, File tmpDirFile) throws IOException {
        File resultFile = File.createTempFile(name, '.' + ext, tmpDirFile);
        resultFile.deleteOnExit();
        FileUtils.copyToFile(inputStream, resultFile);
        return resultFile;
    }

    private static void copyToFile(InputStream source, File destination) throws IOException {
        try (InputStream in = source;
             FileOutputStream out = org.apache.commons.io.FileUtils.openOutputStream((File)destination);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    public static File createTmpFile(InputStream inputStream, String name, String ext) throws IOException {
        return FileUtils.createTmpFile(inputStream, name, ext, Files.createTempDirectory("weixin-java-tools-temp", new FileAttribute[0]).toFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String imageToBase64ByStream(InputStream in) {
        byte[] data = null;
        try {
            data = new byte[in.available()];
            in.read(data);
            String string = Base64.getEncoder().encodeToString(data);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

