/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.executor;

import java.io.IOException;
import java.io.InputStream;
import me.chanjar.weixin.common.bean.CommonUploadData;
import me.chanjar.weixin.common.bean.CommonUploadParam;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.executor.CommonUploadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.apache.Utf8ResponseHandler;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.CloseableHttpClient;

public class CommonUploadRequestExecutorApacheImpl
extends CommonUploadRequestExecutor<CloseableHttpClient, HttpHost> {
    public CommonUploadRequestExecutorApacheImpl(RequestHttp<CloseableHttpClient, HttpHost> requestHttp) {
        super(requestHttp);
    }

    /*
     * Loose catch block
     */
    @Override
    public String execute(String uri, CommonUploadParam param, WxType wxType) throws WxErrorException, IOException {
        HttpPost httpPost = new HttpPost(uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            RequestConfig config = RequestConfig.custom().setProxy((HttpHost)this.requestHttp.getRequestHttpProxy()).build();
            httpPost.setConfig(config);
        }
        if (param != null) {
            CommonUploadData data = param.getData();
            InnerStreamBody part = new InnerStreamBody(data.getInputStream(), ContentType.DEFAULT_BINARY, data.getFileName(), data.getLength());
            HttpEntity entity = MultipartEntityBuilder.create().addPart(param.getName(), (ContentBody)part).setMode(HttpMultipartMode.RFC6532).build();
            httpPost.setEntity(entity);
        }
        try {
            try (CloseableHttpResponse response = ((CloseableHttpClient)this.requestHttp.getRequestHttpClient()).execute((HttpUriRequest)httpPost);){
                String responseContent = (String)Utf8ResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
                if (responseContent == null || responseContent.isEmpty()) {
                    throw new WxErrorException(String.format("\u4e0a\u4f20\u5931\u8d25\uff0c\u670d\u52a1\u5668\u54cd\u5e94\u7a7a url:%s param:%s", uri, param));
                }
                WxError error = WxError.fromJson(responseContent, wxType);
                if (error.getErrorCode() != 0) {
                    throw new WxErrorException(error);
                }
                String string = responseContent;
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            httpPost.releaseConnection();
        }
    }

    public static class InnerStreamBody
    extends InputStreamBody {
        private final long contentLength;

        public InnerStreamBody(InputStream in, ContentType contentType, String filename, long contentLength) {
            super(in, contentType, filename);
            this.contentLength = contentLength;
        }

        public long getContentLength() {
            return this.contentLength;
        }
    }
}

