/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.bean;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class CommonUploadData
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(CommonUploadData.class);
    @Nullable
    private String fileName;
    @NotNull
    private InputStream inputStream;
    private long length;

    public static CommonUploadData fromFile(File file) {
        return new CommonUploadData(file.getName(), Files.newInputStream(file.toPath(), new OpenOption[0]), file.length());
    }

    public byte[] readAllBytes() {
        byte[] bytes = new byte[(int)this.length];
        this.inputStream.read(bytes);
        this.inputStream.close();
        return bytes;
    }

    public String toString() {
        return String.format("{fileName:%s, length:%s}", this.fileName, this.length);
    }

    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @NotNull
    public InputStream getInputStream() {
        return this.inputStream;
    }

    public long getLength() {
        return this.length;
    }

    public void setFileName(@Nullable String fileName) {
        this.fileName = fileName;
    }

    public void setInputStream(@NotNull InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        this.inputStream = inputStream;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonUploadData)) {
            return false;
        }
        CommonUploadData other = (CommonUploadData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        InputStream this$inputStream = this.getInputStream();
        InputStream other$inputStream = other.getInputStream();
        return !(this$inputStream == null ? other$inputStream != null : !this$inputStream.equals(other$inputStream));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonUploadData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $length = this.getLength();
        result = result * 59 + (int)($length >>> 32 ^ $length);
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        InputStream $inputStream = this.getInputStream();
        result = result * 59 + ($inputStream == null ? 43 : $inputStream.hashCode());
        return result;
    }

    public CommonUploadData() {
    }

    public CommonUploadData(@Nullable String fileName, @NotNull InputStream inputStream, long length) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        this.fileName = fileName;
        this.inputStream = inputStream;
        this.length = length;
    }
}

