/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.cp.api.WxCpOAuth2Service;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpOauth2UserInfo;
import me.chanjar.weixin.cp.bean.WxCpUserDetail;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

public class WxCpOAuth2ServiceImpl
implements WxCpOAuth2Service {
    private final WxCpService mainService;

    @Override
    public String buildAuthorizationUrl(String state) {
        return this.buildAuthorizationUrl(this.mainService.getWxCpConfigStorage().getOauth2redirectUri(), state);
    }

    @Override
    public String buildAuthorizationUrl(String redirectUri, String state) {
        return this.buildAuthorizationUrl(redirectUri, state, "snsapi_base");
    }

    @Override
    public String buildAuthorizationUrl(String redirectUri, String state, String scope) {
        StringBuilder url = new StringBuilder("https://open.weixin.qq.com/connect/oauth2/authorize");
        url.append("?appid=").append(this.mainService.getWxCpConfigStorage().getCorpId());
        url.append("&redirect_uri=").append(URIUtil.encodeURIComponent((String)redirectUri));
        url.append("&response_type=code");
        url.append("&scope=").append(scope);
        if ("snsapi_privateinfo".equals(scope) || "snsapi_userinfo".equals(scope)) {
            url.append("&agentid=").append(this.mainService.getWxCpConfigStorage().getAgentId());
        }
        if (state != null) {
            url.append("&state=").append(state);
        }
        url.append("#wechat_redirect");
        return url.toString();
    }

    @Override
    public WxCpOauth2UserInfo getUserInfo(String code) throws WxErrorException {
        return this.getUserInfo(this.mainService.getWxCpConfigStorage().getAgentId(), code);
    }

    @Override
    public WxCpOauth2UserInfo getUserInfo(Integer agentId, String code) throws WxErrorException {
        String responseText = this.mainService.get(String.format(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/user/getuserinfo?code=%s&agentid=%d"), code, agentId), null);
        JsonElement je = new JsonParser().parse(responseText);
        JsonObject jo = je.getAsJsonObject();
        return WxCpOauth2UserInfo.builder().userId(GsonHelper.getString((JsonObject)jo, (String)"UserId")).deviceId(GsonHelper.getString((JsonObject)jo, (String)"DeviceId")).openId(GsonHelper.getString((JsonObject)jo, (String)"OpenId")).userTicket(GsonHelper.getString((JsonObject)jo, (String)"user_ticket")).expiresIn(GsonHelper.getString((JsonObject)jo, (String)"expires_in")).build();
    }

    @Override
    public WxCpUserDetail getUserDetail(String userTicket) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("user_ticket", userTicket);
        String responseText = this.mainService.post(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/user/getuserdetail"), param.toString());
        return (WxCpUserDetail)WxCpGsonBuilder.create().fromJson(responseText, WxCpUserDetail.class);
    }

    public WxCpOAuth2ServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }
}

